const path = require("path");

module.exports = {
    entry: "./src/index.js",  // Source JavaScript file
    output: {
        path: path.resolve(__dirname, "static"),  // Output to Flask's static directory
        filename: "bundle.js",                   // Bundled file name
    },
    module: {
        rules: [
            {
                test: /\.js$/,
                exclude: /node_modules/,
                use: {
                    loader: "babel-loader",       // Transpile modern JavaScript
                },
            },
        ],
    },
    mode: "development",  // Use "production" for production builds otherwise development
    // Other configurations
    devtool: "source-map",
};

