/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/script.js":
/*!***********************!*\
  !*** ./src/script.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   initializeAudioContext: () => (/* binding */ initializeAudioContext),
/* harmony export */   isMobileDevice: () => (/* binding */ isMobileDevice),
/* harmony export */   logToScreen: () => (/* binding */ logToScreen),
/* harmony export */   playAudioBlob: () => (/* binding */ playAudioBlob)
/* harmony export */ });
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
var voices = []; // Global variable to store available voices
var isPaused = false; // Global flag for pause state
// === Initialize Audio Context (Global) ===
var audioContext = null;

// Array of phase titles
var phases = ["INTRODUCTION", "FLOW RHYTHM", "RESOURCE STATE I", "DECOMPRESSION RHYTHM", "RESOURCE STATE II", "FREEZING", "DECOMPRESSION PROCESS", "RESOURCE STATE II", "RESOURCE RHYTM", "RESOURCE STATE I", "RESOURCE STATE II", "RESOURCE-RHYTHM AND REENTERING INTO HERE AND NOW", "CLOSING STATEMENT", "CONCLUSION"];
function isMobileDevice() {
  return /Mobi|Android|iPhone|iPad|iPod/i.test(navigator.userAgent);
}
function logToScreen(message) {
  var logDiv = document.getElementById("log");
  if (!logDiv) {
    logDiv = document.createElement("div");
    logDiv.id = "log";
    logDiv.style = "position:fixed;bottom:0;left:0;width:100%;height:150px;background:white;overflow:auto;font-size:14px;z-index:9999;padding:10px;border-top:1px solid black;";
    document.body.appendChild(logDiv);
  }
  logDiv.innerHTML += "<div>".concat(message, "</div>");
}
function unlockAudio() {
  var unlock = new Audio();
  unlock.src = "data:audio/wav;base64,UklGRiQAAABXQVZFZm10IBAAAAABAAEARKwAABCxAgAEABAAZGF0YQAAAAA="; // Silent WAV
  unlock.play()
  // .then(() => logToScreen("Unlock audio success!"))
  // .catch(e => logToScreen("Unlock audio failed: " + e.message));
  .then(function () {
    return console.log("Unlock audio success!");
  })["catch"](function (e) {
    return console.log("Unlock audio failed: " + e.message);
  });
}
function initializeAudioContext() {
  if (!audioContext) {
    audioContext = new (window.AudioContext || window.webkitAudioContext)();
    // logToScreen("AudioContext created.");
    console.log("AudioContext created.");
  }
  if (audioContext.state === "suspended") {
    // audioContext.resume().then(() => logToScreen("AudioContext resumed."));
    audioContext.resume().then(function () {
      return console.log("AudioContext resumed.");
    });
  }
}

// === Function to Play Audio Using AudioContext ===
function playAudioBlob(_x) {
  return _playAudioBlob.apply(this, arguments);
}
function _playAudioBlob() {
  _playAudioBlob = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4(audioBlob) {
    return _regeneratorRuntime().wrap(function _callee4$(_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          return _context4.abrupt("return", new Promise(/*#__PURE__*/function () {
            var _ref3 = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3(resolve, reject) {
              var arrayBuffer, audioBuffer, source;
              return _regeneratorRuntime().wrap(function _callee3$(_context3) {
                while (1) switch (_context3.prev = _context3.next) {
                  case 0:
                    _context3.prev = 0;
                    _context3.next = 3;
                    return audioBlob.arrayBuffer();
                  case 3:
                    arrayBuffer = _context3.sent;
                    _context3.next = 6;
                    return audioContext.decodeAudioData(arrayBuffer);
                  case 6:
                    audioBuffer = _context3.sent;
                    source = audioContext.createBufferSource();
                    source.buffer = audioBuffer;
                    source.connect(audioContext.destination);

                    // source.onended = () => resolve();
                    source.onended = function () {
                      console.log("Audio playback finished.");
                      // logToScreen("Audio playback finished.");
                      resolve();
                    };
                    source.start(0);
                    console.log("Audio playback started.");
                    // logToScreen("Audio playback started.");
                    _context3.next = 19;
                    break;
                  case 15:
                    _context3.prev = 15;
                    _context3.t0 = _context3["catch"](0);
                    console.log("Error during playback: " + _context3.t0.message);
                    // logToScreen("Error during playback: " + error.message);
                    reject(_context3.t0);
                  case 19:
                  case "end":
                    return _context3.stop();
                }
              }, _callee3, null, [[0, 15]]);
            }));
            return function (_x6, _x7) {
              return _ref3.apply(this, arguments);
            };
          }()));
        case 1:
        case "end":
          return _context4.stop();
      }
    }, _callee4);
  }));
  return _playAudioBlob.apply(this, arguments);
}
function populatePhaseColumn() {
  var phaseColumn = document.getElementById('phaseColumn');
  phases.forEach(function (phase, index) {
    var row = document.createElement('div');
    row.classList.add('phase-row');
    row.textContent = phase;
    row.dataset.phaseIndex = index;
    phaseColumn.appendChild(row);
  });
}
function activatePhaseAAAA(phaseIndex) {
  var phaseRows = document.querySelectorAll('.phase-row');
  phaseRows.forEach(function (row) {
    return row.classList.remove('active');
  });
  var activeRow = document.querySelector(".phase-row[data-phase-index=\"".concat(phaseIndex, "\"]"));
  if (activeRow) {
    activeRow.classList.add('active');
  }
}
function activatePhaseBBBBB(phaseIndex) {
  // Target normal phase rows (desktop mode)
  var phaseRows = document.querySelectorAll('.phase-row');
  phaseRows.forEach(function (row) {
    return row.classList.remove('active');
  });
  var activeRow = document.querySelector(".phase-row[data-phase-index=\"".concat(phaseIndex, "\"]"));
  if (activeRow) {
    activeRow.classList.add('active');
  }

  // Target overlay phase rows (when overlay is open)
  var phaseOverlay = document.getElementById('phaseOverlay');
  if (phaseOverlay && phaseOverlay.style.display !== 'none') {
    // Ensure overlay is visible
    var overlayRows = phaseOverlay.querySelectorAll('.phaseOverlayRow');
    overlayRows.forEach(function (row) {
      return row.classList.remove('active');
    });
    var activeOverlayRow = phaseOverlay.querySelector(".phaseOverlayRow[data-phase-index=\"".concat(phaseIndex, "\"]"));
    if (activeOverlayRow) {
      activeOverlayRow.classList.add('active');
    }
  }
}
function activatePhaseCCCCC(phaseIndex) {
  // Handle desktop phase rows inside #phaseColumn
  document.querySelectorAll('#phaseColumn .phase-row').forEach(function (row) {
    return row.classList.remove('active');
  });
  var activeRow = document.querySelector("#phaseColumn .phase-row[data-phase-index=\"".concat(phaseIndex, "\"]"));
  if (activeRow) {
    activeRow.classList.add('active');
  }

  // Handle mobile overlay phase rows inside #phaseList
  document.querySelectorAll('#phaseList .phase-row').forEach(function (row) {
    return row.classList.remove('active');
  });
  var activeOverlayRow = document.querySelector("#phaseList .phase-row[data-phase-index=\"".concat(phaseIndex, "\"]"));
  if (activeOverlayRow) {
    activeOverlayRow.classList.add('active');
    console.log("Activated phase in overlay:", activeOverlayRow);
  }
}
function activatePhase(phaseIndex) {
  // Handle desktop phase rows inside #phaseColumn
  document.querySelectorAll('#phaseColumn .phase-row').forEach(function (row) {
    return row.classList.remove('active');
  });
  var activeRow = document.querySelector("#phaseColumn .phase-row[data-phase-index=\"".concat(phaseIndex, "\"]"));
  if (activeRow) {
    activeRow.classList.add('active');
  }

  // Handle overlay phase rows inside #phaseList
  document.querySelectorAll('#phaseList .phase-row').forEach(function (row) {
    return row.classList.remove('active');
  });
  var activeOverlayRow = document.querySelector("#phaseList .phase-row[data-phase-index=\"".concat(phaseIndex, "\"]"));
  if (activeOverlayRow) {
    activeOverlayRow.classList.add('active');
    console.log("✅ Activated phase in overlay:", activeOverlayRow);
  } else {
    console.log("x No matching overlay row found for index ".concat(phaseIndex));
  }
}

// Call this function once to populate the phase column on load
document.addEventListener('DOMContentLoaded', populatePhaseColumn);

// Example call to activate the phase, can be called within getNextPhase or displayInstructions
activatePhase(0); // Set initial phase as active

// Function to clear feedback and recommendation sections
function clearFeedbackAndRecommendation() {
  document.getElementById('feedbackInput').value = ''; // Clear feedback input
  document.getElementById('recommendation').innerText = ''; // Clear recommendation display
}

// Function to clear the radio buttons and feedback box immediately after selection
function clearFeedbackAndRadioButtons() {
  document.getElementById('feedbackBox').style.display = 'none'; // Hide feedback box
  document.getElementById('questions').style.display = 'none'; // Hide radio buttons
  document.getElementById('questions').innerHTML = ''; // Clear radio buttons content
}
function stopSpeech() {
  if (window.speechSynthesis.speaking || window.speechSynthesis.pending) {
    window.speechSynthesis.cancel();
  }
}

// Dummy function for testing that does nothing
function speakText(text) {
  var voiceName = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'Aaron';
} // Intentionally left blank to bypass voice output
function speakTextAfterVoicesLoaded(text) {
  var voiceName = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'Aaron';
  console.log("Opening function speakTextAfterVoicesLoaded:", text);
  if (typeof text !== 'string') {
    console.log("Non-string input detected in speakTextAfterVoicesLoaded:", text);
    return; // Exit if the input is not a string
  }

  // Wait for voices to load if they haven't yet
  if (voices.length === 0) {
    setTimeout(function () {
      return speakTextAfterVoicesLoaded(text, voiceName);
    }, 100);
  } else {
    speakTextUnified(text, voiceName); // Pass both text and voiceName to speakText
  }
}
function scrollToBottom() {
  var box = document.querySelector('.instructions-box');
  if (box) {
    requestAnimationFrame(function () {
      box.scrollTop = box.scrollHeight;
      console.log("🔽 Forced Scroll:", box.scrollTop, "/", box.scrollHeight);
    });
  }
}
function scrollToBottomZZZZZ() {
  var box = document.querySelector('.instructions-box');
  if (box) {
    setTimeout(function () {
      box.scrollTop = box.scrollHeight;
      console.log("🔽 Forced Scroll:", box.scrollTop, "/", box.scrollHeight);
    }, 0); // Ensures scrolling happens after content updates
  }
}
function typeText(element, html, letterDelay) {
  return new Promise(function (resolve) {
    var currentIndex = 0;
    var box = document.querySelector('.instructions-box');
    function typeNextLetter() {
      if (currentIndex < html.length) {
        if (html[currentIndex] === '<') {
          var closingTagIndex = html.indexOf('>', currentIndex) + 1;
          element.innerHTML += html.slice(currentIndex, closingTagIndex);
          currentIndex = closingTagIndex;
        } else {
          element.innerHTML += html[currentIndex];
          currentIndex++;
        }

        // Call scrolling function to keep text in view
        requestAnimationFrame(scrollToBottom);
        setTimeout(typeNextLetter, letterDelay);
      } else {
        resolve();
      }
    }
    typeNextLetter();
  });
}
function typeTextZZZZZ(element, html, letterDelay) {
  return new Promise(function (resolve) {
    var currentIndex = 0;
    var box = document.querySelector('.instructions-box');
    function typeNextLetter() {
      if (currentIndex < html.length) {
        if (html[currentIndex] === '<') {
          var closingTagIndex = html.indexOf('>', currentIndex) + 1;
          element.innerHTML += html.slice(currentIndex, closingTagIndex);
          currentIndex = closingTagIndex;
        } else {
          element.innerHTML += html[currentIndex];
          currentIndex++;
        }

        // Scroll after adding each letter
        requestAnimationFrame(scrollToBottom);
        setTimeout(typeNextLetter, letterDelay);
      } else {
        resolve();
      }
    }
    typeNextLetter();
  });
}
function typeTextFFFFFFF(element, html, letterDelay) {
  return new Promise(function (resolve) {
    var currentIndex = 0;
    var box = document.querySelector('.instructions-box');
    function typeNextLetter() {
      if (currentIndex < html.length) {
        if (html[currentIndex] === '<') {
          var closingTagIndex = html.indexOf('>', currentIndex) + 1;
          element.innerHTML += html.slice(currentIndex, closingTagIndex);
          currentIndex = closingTagIndex;
        } else {
          element.innerHTML += html[currentIndex];
          currentIndex++;
        }

        // Scroll to the bottom smoothly as text appears
        if (box) {
          box.scrollTop = box.scrollHeight;
        }
        setTimeout(typeNextLetter, letterDelay);
      } else {
        resolve();
      }
    }
    typeNextLetter();
  });
}
function typeTextDDDDD(element, html, letterDelay) {
  return new Promise(function (resolve) {
    var currentIndex = 0;
    function typeNextLetter() {
      if (currentIndex < html.length) {
        if (html[currentIndex] === '<') {
          var closingTagIndex = html.indexOf('>', currentIndex) + 1;
          element.innerHTML += html.slice(currentIndex, closingTagIndex);
          currentIndex = closingTagIndex;
        } else {
          element.innerHTML += html[currentIndex];
          currentIndex++;
        }
        setTimeout(typeNextLetter, letterDelay);
      } else {
        resolve();
      }
    }
    typeNextLetter();
  });
}
function formatText(text) {
  console.log("Original text:", text); // Log original text for debugging

  // Handle <bold> and <big> custom tags
  text = text.replace(/<bold>(.*?)<\/bold>/g, '<span class="bold-text">$1</span>').replace(/<big>(.*?)<\/big>/g, '<span class="big-text">$1</span>').replace(/<bold,\s?big>(.*?)<\/bold,\s?\/big>/g, '<span class="bold-big-text">$1</span>');

  // Ensure the closing tags are properly applied for <bold, big>
  text = text.replace(/<\/bold,\s?\/big>/g, '</span>');

  // Handle <problem> tag (if it needs to be removed or styled differently)
  text = text.replace(/<problem>/g, '').replace(/<\/problem>/g, '');

  // Keep (A), (B), (C), and (Z) intact by NOT modifying anything inside parentheses
  text = text.replace(/-\s([A-Z]\))\s+/g, function (match, p1) {
    return "<span class=\"bold-text\">".concat(p1.trim(), "</span>");
  });
  console.log("After replacing custom tags:", text); // Log the text after replacing custom tags

  return text;
}
function playSound(filename) {
  return new Promise(function (resolve, reject) {
    var audioElement = new Audio("/static/".concat(filename, ".mp4"));

    // Resolve the promise when the sound finishes
    audioElement.onended = function () {
      console.log("Sound ".concat(filename, " finished playing."));
      resolve();
    };

    // Reject if there's an error
    audioElement.onerror = function (error) {
      console.error("Error playing sound ".concat(filename, ":"), error);
      reject(error);
    };
    audioElement.play()["catch"](function (error) {
      console.error("Play error for ".concat(filename, ":"), error);
      resolve(); // Resolve even on error to prevent blocking
    });
  });
}
function displayGoodbyeInstructions(_x2) {
  return _displayGoodbyeInstructions.apply(this, arguments);
} //
//function scrollToBottom() {
//    var box = document.querySelector('.instructions-box');
//    if (box) {
//        box.scrollTop = box.scrollHeight;
//    }
//}
function _displayGoodbyeInstructions() {
  _displayGoodbyeInstructions = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee5(segmentedInstructions) {
    var instructionsDiv, _iterator, _step, segment, soundFile, lines, _iterator2, _step2, line, goodbyeParagraph;
    return _regeneratorRuntime().wrap(function _callee5$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          console.log("Show Segmented Good Bye Instructions:", segmentedInstructions);
          instructionsDiv = document.getElementById('instructions');
          instructionsDiv.innerHTML = ''; // Clear previous instructions
          _iterator = _createForOfIteratorHelper(segmentedInstructions);
          _context5.prev = 4;
          _iterator.s();
        case 6:
          if ((_step = _iterator.n()).done) {
            _context5.next = 44;
            break;
          }
          segment = _step.value;
          if (!(segment.type === "sound")) {
            _context5.next = 15;
            break;
          }
          // Play sound and wait for it to finish
          soundFile = segment.value;
          console.log("Playing sound file:", soundFile);
          _context5.next = 13;
          return playSound(soundFile);
        case 13:
          _context5.next = 42;
          break;
        case 15:
          if (!(segment.type === "text")) {
            _context5.next = 42;
            break;
          }
          // Split the text segment into lines based on line breaks
          lines = segment.value.split('\n');
          _iterator2 = _createForOfIteratorHelper(lines);
          _context5.prev = 18;
          _iterator2.s();
        case 20:
          if ((_step2 = _iterator2.n()).done) {
            _context5.next = 34;
            break;
          }
          line = _step2.value;
          if (!(line.trim() === '')) {
            _context5.next = 24;
            break;
          }
          return _context5.abrupt("continue", 32);
        case 24:
          // Skip empty lines
          // Display the line
          goodbyeParagraph = document.createElement('p');
          goodbyeParagraph.id = 'goodbyeParagraph';
          instructionsDiv.appendChild(goodbyeParagraph);
          _context5.next = 29;
          return typeText(goodbyeParagraph, line.trim(), 10);
        case 29:
          // Display line gradually
          goodbyeParagraph.style.display = 'flex';
          // Log and wait for speech synthesis of this line to finish
          // console.log("Speaking line:", line.trim());  // Debugging line
          _context5.next = 32;
          return speakTextUnified(line.trim());
        case 32:
          _context5.next = 20;
          break;
        case 34:
          _context5.next = 39;
          break;
        case 36:
          _context5.prev = 36;
          _context5.t0 = _context5["catch"](18);
          _iterator2.e(_context5.t0);
        case 39:
          _context5.prev = 39;
          _iterator2.f();
          return _context5.finish(39);
        case 42:
          _context5.next = 6;
          break;
        case 44:
          _context5.next = 49;
          break;
        case 46:
          _context5.prev = 46;
          _context5.t1 = _context5["catch"](4);
          _iterator.e(_context5.t1);
        case 49:
          _context5.prev = 49;
          _iterator.f();
          return _context5.finish(49);
        case 52:
        case "end":
          return _context5.stop();
      }
    }, _callee5, null, [[4, 46, 49, 52], [18, 36, 39, 42]]);
  }));
  return _displayGoodbyeInstructions.apply(this, arguments);
}
function displayInstructions(_x3) {
  return _displayInstructions.apply(this, arguments);
}
function _displayInstructions() {
  _displayInstructions = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee6(segmentedInstructions) {
    var instructionsDiv, pauseButton, _iterator3, _step3, segment, soundFile, lines, _iterator4, _step4, _loop, _ret;
    return _regeneratorRuntime().wrap(function _callee6$(_context7) {
      while (1) switch (_context7.prev = _context7.next) {
        case 0:
          console.log("Show Segmented Instructions:", segmentedInstructions);
          instructionsDiv = document.getElementById('instructions');
          pauseButton = document.getElementById('pauseButton'); // Show the pause button when the loop starts
          if (pauseButton) pauseButton.style.display = 'block';
          instructionsDiv.innerHTML = ''; // Clear previous instructions
          _iterator3 = _createForOfIteratorHelper(segmentedInstructions);
          _context7.prev = 6;
          _iterator3.s();
        case 8:
          if ((_step3 = _iterator3.n()).done) {
            _context7.next = 40;
            break;
          }
          segment = _step3.value;
          if (!(segment.type === "sound")) {
            _context7.next = 17;
            break;
          }
          soundFile = segment.value;
          console.log("Playing sound file:", soundFile);
          _context7.next = 15;
          return playSound(soundFile);
        case 15:
          _context7.next = 38;
          break;
        case 17:
          if (!(segment.type === "text")) {
            _context7.next = 38;
            break;
          }
          lines = segment.value.split('\n');
          _iterator4 = _createForOfIteratorHelper(lines);
          _context7.prev = 20;
          _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop() {
            var line, waitMatch, waitTime, paragraph;
            return _regeneratorRuntime().wrap(function _loop$(_context6) {
              while (1) switch (_context6.prev = _context6.next) {
                case 0:
                  line = _step4.value;
                  if (!(line.trim() === '')) {
                    _context6.next = 3;
                    break;
                  }
                  return _context6.abrupt("return", 0);
                case 3:
                  if (!isPaused) {
                    _context6.next = 9;
                    break;
                  }
                  console.log("Paused... waiting to continue.");
                  _context6.next = 7;
                  return new Promise(function (resolve) {
                    return setTimeout(resolve, 100);
                  });
                case 7:
                  _context6.next = 3;
                  break;
                case 9:
                  waitMatch = line.match(/<wait:(\d+)>/);
                  if (!waitMatch) {
                    _context6.next = 16;
                    break;
                  }
                  waitTime = parseInt(waitMatch[1], 10);
                  console.log("Waiting for ".concat(waitTime, " milliseconds..."));
                  _context6.next = 15;
                  return new Promise(function (resolve) {
                    return setTimeout(resolve, waitTime);
                  });
                case 15:
                  return _context6.abrupt("return", 0);
                case 16:
                  paragraph = document.createElement('p');
                  instructionsDiv.appendChild(paragraph);
                  _context6.next = 20;
                  return typeText(paragraph, line.trim(), 10);
                case 20:
                  // Display line gradually

                  console.log("Speaking line:", line.trim());
                  _context6.next = 23;
                  return speakTextUnified(line.trim());
                case 23:
                case "end":
                  return _context6.stop();
              }
            }, _loop);
          });
          _iterator4.s();
        case 23:
          if ((_step4 = _iterator4.n()).done) {
            _context7.next = 30;
            break;
          }
          return _context7.delegateYield(_loop(), "t0", 25);
        case 25:
          _ret = _context7.t0;
          if (!(_ret === 0)) {
            _context7.next = 28;
            break;
          }
          return _context7.abrupt("continue", 28);
        case 28:
          _context7.next = 23;
          break;
        case 30:
          _context7.next = 35;
          break;
        case 32:
          _context7.prev = 32;
          _context7.t1 = _context7["catch"](20);
          _iterator4.e(_context7.t1);
        case 35:
          _context7.prev = 35;
          _iterator4.f();
          return _context7.finish(35);
        case 38:
          _context7.next = 8;
          break;
        case 40:
          _context7.next = 45;
          break;
        case 42:
          _context7.prev = 42;
          _context7.t2 = _context7["catch"](6);
          _iterator3.e(_context7.t2);
        case 45:
          _context7.prev = 45;
          _iterator3.f();
          return _context7.finish(45);
        case 48:
          // Hide the pause button when the loop ends
          if (pauseButton) pauseButton.style.display = 'none';

          // showFeedbackAndQuestions();
        case 49:
        case "end":
          return _context7.stop();
      }
    }, _callee6, null, [[6, 42, 45, 48], [20, 32, 35, 38]]);
  }));
  return _displayInstructions.apply(this, arguments);
}
function displayQuestions(_x4) {
  return _displayQuestions.apply(this, arguments);
} // Function to display the OpenAI input box
function _displayQuestions() {
  _displayQuestions = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee7(questions) {
    var questionContainer, form, aiTriggered, submitButton;
    return _regeneratorRuntime().wrap(function _callee7$(_context8) {
      while (1) switch (_context8.prev = _context8.next) {
        case 0:
          questionContainer = document.getElementById('questions');
          console.log('call displayQuestions with questionContainer:', questionContainer);
          questionContainer.innerHTML = ''; // Clear previous questions
          form = document.createElement('form');
          form.style.flexDirection = 'column';
          aiTriggered = false; // Track if the AI-triggering question is present
          questions.forEach(function (question, index) {
            var label = document.createElement('label');
            var radio = document.createElement('input');
            radio.type = 'radio';
            radio.name = 'choice';
            radio.value = question.choice;
            var cleanText = question.text.replace(/\([A-Z]\)\s*/, ''); // Clean up choice text
            label.innerHTML = cleanText;
            label.prepend(radio);
            form.appendChild(label);

            // Check if the question is a (Z)-triggered question
            if (question.text.includes("(Z)")) {
              aiTriggered = true;
              label.innerHTML += " (Requires AI input)";
              radio.addEventListener('change', function () {
                showOpenAIInputField(); // Trigger OpenAI input field
              });
            }
            if (index === 0) {
              radio.checked = true;
            }
          });
          submitButton = document.createElement('button');
          submitButton.type = 'button';
          submitButton.id = 'submitButton';
          submitButton.className = 'button-custom';
          submitButton.innerText = 'Submit';
          submitButton.onclick = function () {
            var selectedChoice = form.querySelector('input[name="choice"]:checked');
            if (selectedChoice) {
              if (aiTriggered && selectedChoice.value === "(Z)") {
                handleOpenAIInput(); // Handle AI-specific input
              } else {
                console.log('Clearing Radio-Buttons after Submit, in case selectedChoice:', selectedChoice);
                clearFeedbackAndRadioButtons(); // Clear previous feedback and radio buttons
                console.log('call getNextPhase with selected choice:', selectedChoice.value);
                getNextPhase(selectedChoice.value);
              }
            } else {
              alert('Please select an option.');
            }
          };
          form.appendChild(submitButton);
          questionContainer.appendChild(form);

          // Show questions container
          showRadioButtons();

          // Ensure the AI input field is shown if (Z) question is selected by default
          if (aiTriggered) {
            showOpenAIInputField();
          }
        case 17:
        case "end":
          return _context8.stop();
      }
    }, _callee7);
  }));
  return _displayQuestions.apply(this, arguments);
}
function showOpenAIInputField() {
  var openAIInput = document.createElement('textarea');
  openAIInput.id = 'openAIInput';
  openAIInput.placeholder = 'Please provide your input for AI...';
  openAIInput.style.width = '100%';
  openAIInput.style.height = '100px';

  // Append the input field under the questions
  document.getElementById('questions').appendChild(openAIInput);
}
function handleOpenAIInput() {
  return _handleOpenAIInput.apply(this, arguments);
}
function _handleOpenAIInput() {
  _handleOpenAIInput = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee8() {
    var aiInput, response, data, recommendationElement;
    return _regeneratorRuntime().wrap(function _callee8$(_context9) {
      while (1) switch (_context9.prev = _context9.next) {
        case 0:
          console.log("Start HandleOpenAIInput");
          aiInput = document.getElementById('openAIInput');
          if (!(aiInput && aiInput.value.trim())) {
            _context9.next = 25;
            break;
          }
          console.log('Sending input to OpenAI:', aiInput.value);
          _context9.prev = 4;
          _context9.next = 7;
          return fetch('/api/openai', {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json'
            },
            body: JSON.stringify({
              prompt: aiInput.value
            })
          });
        case 7:
          response = _context9.sent;
          _context9.next = 10;
          return response.json();
        case 10:
          data = _context9.sent;
          recommendationElement = document.getElementById('recommendation');
          recommendationElement.innerText = data.output;
          console.log("Speaking OpenAI output:", data.output);
          _context9.next = 16;
          return speakTextUnified(data.output);
        case 16:
          // Ensure AI output is spoken sequentially

          // Clear fields and move to the next phase
          console.log("Clearing Radio-Buttons after AI Output");
          clearFeedbackAndRadioButtons();
          _context9.next = 23;
          break;
        case 20:
          _context9.prev = 20;
          _context9.t0 = _context9["catch"](4);
          console.error('Error with OpenAI API:', _context9.t0);
        case 23:
          _context9.next = 26;
          break;
        case 25:
          alert('Please provide your input for AI.');
        case 26:
        case "end":
          return _context9.stop();
      }
    }, _callee8, null, [[4, 20]]);
  }));
  return _handleOpenAIInput.apply(this, arguments);
}
function hideRadioButtons() {
  document.getElementById('questions').style.display = 'none';
}
function showRadioButtons() {
  document.getElementById('questions').style.display = 'flex';
}
function showFeedbackAndQuestions(_x5) {
  return _showFeedbackAndQuestions.apply(this, arguments);
}
function _showFeedbackAndQuestions() {
  _showFeedbackAndQuestions = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee9(phase) {
    var feedbackBox, feedbackInput, feedbackLabel;
    return _regeneratorRuntime().wrap(function _callee9$(_context10) {
      while (1) switch (_context10.prev = _context10.next) {
        case 0:
          console.log("[".concat(new Date().toISOString(), "] showFeedbackAndQuestions called with phase: ").concat(phase));
          feedbackBox = document.getElementById('feedbackBox');
          feedbackBox.style.display = 'flex'; // Show feedback box
          feedbackInput = document.getElementById('feedbackInput');
          feedbackLabel = document.querySelector('label[for="feedbackInput"]');
          if (!(phase === 1)) {
            _context10.next = 12;
            break;
          }
          console.log("[".concat(new Date().toISOString(), "] Executing phase 1 one block"));
          feedbackLabel.textContent = "How does this sound to you? Shall we start? You can also ask me any question about the process.";
          _context10.next = 10;
          return speakTextUnified(feedbackLabel.textContent);
        case 10:
          _context10.next = 16;
          break;
        case 12:
          console.log("[".concat(new Date().toISOString(), "] Executing else 1 one block"));
          feedbackLabel.textContent = "How did the last part of the session work for you?";
          _context10.next = 16;
          return speakTextUnified(feedbackLabel.textContent);
        case 16:
          setTimeout(function () {
            feedbackInput.focus();
            console.log("[".concat(new Date().toISOString(), "] Attempting to focus feedback input"));
            if (document.activeElement === feedbackInput) {
              console.log('Feedback input is focused');
            } else {
              console.log('Focus failed on feedback input');
            }
          }, 100); // Delay to ensure rendering
        case 17:
        case "end":
          return _context10.stop();
      }
    }, _callee9);
  }));
  return _showFeedbackAndQuestions.apply(this, arguments);
}
function getNextPhase() {
  return _getNextPhase.apply(this, arguments);
}
function _getNextPhase() {
  _getNextPhase = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee10() {
    var choice,
      response,
      data,
      _args11 = arguments;
    return _regeneratorRuntime().wrap(function _callee10$(_context11) {
      while (1) switch (_context11.prev = _context11.next) {
        case 0:
          choice = _args11.length > 0 && _args11[0] !== undefined ? _args11[0] : "A";
          _context11.prev = 1;
          clearFeedbackAndRecommendation(); // Clear previous feedback and recommendation
          _context11.next = 5;
          return fetch('/next-phase', {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json'
            },
            body: JSON.stringify({
              choice: choice
            })
          });
        case 5:
          response = _context11.sent;
          if (response.ok) {
            _context11.next = 8;
            break;
          }
          throw new Error('Bad Request: ' + response.statusText);
        case 8:
          _context11.next = 10;
          return response.json();
        case 10:
          data = _context11.sent;
          console.log('Phase received:', data.phase);
          console.log('Instructions received:', data.segmentedInstructions);

          // Highlight the active phase using data.phase
          activatePhase(data.phase - 1);
          if (data.is_last_phase) {
            _context11.next = 24;
            break;
          }
          _context11.next = 17;
          return displayInstructions(data.segmentedInstructions || 'No instructions received', data.soundFiles || []);
        case 17:
          _context11.next = 19;
          return displayQuestions(data.questions || []);
        case 19:
          // Hide radio buttons
          hideRadioButtons();

          // Show feedback box and update label based on phase
          console.log("Calling showFeedbackAndQuestions:", data.phase);
          showFeedbackAndQuestions(data.phase); // Pass the current phase to the function
          _context11.next = 27;
          break;
        case 24:
          _context11.next = 26;
          return displayGoodbyeInstructions(data.segmentedInstructions || 'No instructions received', data.soundFiles || []);
        case 26:
          //speakTextAfterVoicesLoaded(data.segmentedInstructions || 'No instructions received');
          feedbackBox.style.display = 'none'; // Do not show feedback box
          // await displayQuestions(data.questions || []);
        case 27:
          _context11.next = 32;
          break;
        case 29:
          _context11.prev = 29;
          _context11.t0 = _context11["catch"](1);
          console.error("Error fetching the next phase:", _context11.t0);
        case 32:
        case "end":
          return _context11.stop();
      }
    }, _callee10, null, [[1, 29]]);
  }));
  return _getNextPhase.apply(this, arguments);
}
function resetPhase() {
  return _resetPhase.apply(this, arguments);
}
function _resetPhase() {
  _resetPhase = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee11() {
    var response, data;
    return _regeneratorRuntime().wrap(function _callee11$(_context12) {
      while (1) switch (_context12.prev = _context12.next) {
        case 0:
          _context12.prev = 0;
          _context12.next = 3;
          return fetch('/reset-phase', {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json'
            }
          });
        case 3:
          response = _context12.sent;
          if (response.ok) {
            _context12.next = 6;
            break;
          }
          throw new Error('Failed to reset phase: ' + response.statusText);
        case 6:
          _context12.next = 8;
          return response.json();
        case 8:
          data = _context12.sent;
          console.log(data.message);
          _context12.next = 15;
          break;
        case 12:
          _context12.prev = 12;
          _context12.t0 = _context12["catch"](0);
          console.error("Error resetting phase:", _context12.t0);
        case 15:
        case "end":
          return _context12.stop();
      }
    }, _callee11, null, [[0, 12]]);
  }));
  return _resetPhase.apply(this, arguments);
}
function showGoodbyeMessage(goodbyeText) {
  // Clear all dynamic content from the content area
  var contentArea = document.getElementById('contentArea');
  contentArea.innerHTML = ''; // Clear all previous content

  // Create the goodbye message element
  var goodbyeMessage = document.createElement('div');
  goodbyeMessage.id = 'goodbyeMessage';
  goodbyeMessage.textContent = goodbyeText; // Set the text from the last phase

  // Append the goodbye message to the content area
  contentArea.appendChild(goodbyeMessage);

  // Apply the display style to show the goodbye message
  goodbyeMessage.style.display = 'flex';
}
function handleEndOfProcess() {
  return _handleEndOfProcess.apply(this, arguments);
}
function _handleEndOfProcess() {
  _handleEndOfProcess = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee12() {
    var response, data, goodbyeInstructions;
    return _regeneratorRuntime().wrap(function _callee12$(_context13) {
      while (1) switch (_context13.prev = _context13.next) {
        case 0:
          _context13.prev = 0;
          _context13.next = 3;
          return fetch('/next-phase', {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json'
            },
            body: JSON.stringify({
              choice: "A"
            }) // Adjust as necessary to indicate the end phase
          });
        case 3:
          response = _context13.sent;
          if (response.ok) {
            _context13.next = 6;
            break;
          }
          throw new Error('Failed to fetch the last phase: ' + response.statusText);
        case 6:
          _context13.next = 8;
          return response.json();
        case 8:
          data = _context13.sent;
          goodbyeInstructions = data.instructions || "Thank you for participating."; // Default if no instructions
          // Display the goodbye message with the last phase's instructions
          showGoodbyeMessage(goodbyeInstructions);
          _context13.next = 16;
          break;
        case 13:
          _context13.prev = 13;
          _context13.t0 = _context13["catch"](0);
          console.error("Error handling the end of the process:", _context13.t0);
        case 16:
        case "end":
          return _context13.stop();
      }
    }, _callee12, null, [[0, 13]]);
  }));
  return _handleEndOfProcess.apply(this, arguments);
}
document.addEventListener("DOMContentLoaded", function () {
  function setupMasonryGrid() {
    var grid = document.getElementById("masonryGrid");
    var items = grid.querySelectorAll(".masonry-item");

    // Ensure an odd number of images (at least 7)
    var minImages = 7;
    if (items.length % 2 === 0) minImages += 1; // Make sure it's odd

    if (items.length < minImages) {
      for (var i = items.length; i < minImages; i++) {
        var clone = items[i % items.length].cloneNode(true);
        grid.appendChild(clone);
      }
      items = grid.querySelectorAll(".masonry-item"); // Refresh list
    }
    console.log("\u2705 Total images in grid: ".concat(items.length));

    // Determine columns based on viewport width
    var columns = window.innerWidth < 600 ? 2 : 3;

    // Apply grid styles dynamically
    grid.style.gridTemplateColumns = "repeat(".concat(columns, ", 1fr)");
    grid.style.gridAutoRows = "minmax(100px, auto)";
    grid.style.gridAutoFlow = "dense"; // Forces grid to pack tightly

    var twoColumnUsed = false; // ✅ Ensure only one `colSpan: 2` per row
    var threeColumnUsed = false; // ✅ Ensure at least one `colSpan: 3`

    items.forEach(function (item, index) {
      var colSpan = 1; // Default: 1 column
      var rowSpan = Math.random() > 0.7 ? 2 : 1; // 30% chance of spanning 2 rows

      // ✅ Ensure only ONE `colSpan: 2` is used in a row to prevent gaps
      if (!twoColumnUsed && Math.random() > 0.6) {
        colSpan = 2;
        twoColumnUsed = true;
      }

      // ✅ Ensure at least ONE image spans all 3 columns
      if (!threeColumnUsed && Math.random() > 0.8) {
        colSpan = 3;
        threeColumnUsed = true;
      }

      // ✅ Prevent images from exceeding grid columns
      if (colSpan > columns) colSpan = columns;
      item.style.gridColumn = "span ".concat(colSpan);
      item.style.gridRow = "span ".concat(rowSpan);
      console.log("\uD83D\uDCCC Image ".concat(index + 1, " \u2192 colSpan: ").concat(colSpan, ", rowSpan: ").concat(rowSpan));
    });

    // ✅ If no image was assigned `colSpan: 3`, assign it to the last one
    if (!threeColumnUsed && columns === 3) {
      items[items.length - 1].style.gridColumn = "span 3";
      console.log("⚠️ Last image forced to span 3 columns to fix layout.");
    }
  }

  // Run setup function on page load
  setupMasonryGrid();

  // Recalculate layout when the window is resized
  window.addEventListener("resize", setupMasonryGrid);
});
document.addEventListener('DOMContentLoaded', function () {
  //const overlay = document.getElementById("mobileOverlay");

  //   function hideOverlay() {
  //       if (!overlay) return;

  //       overlay.classList.add("mobile-overlay-hidden");

  // Fully remove it from DOM after fade-out
  //      setTimeout(() => {
  //          overlay.style.display = "none";
  //      }, 500); // Matches CSS transition duration
  //    }

  // Hide overlay automatically when it's done fading out
  //    if (overlay) {
  //         overlay.addEventListener("transitionend", hideOverlay);
  //    }

  document.getElementById('button-start').addEventListener('click', /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          initializeAudioContext(); // Unlock AudioContext inside user interaction
          unlockAudio(); // Play silent audio inside user gesture
          _context.next = 4;
          return resetPhase();
        case 4:
          document.getElementById('button-start').style.display = 'none';
          hideRadioButtons();
          getNextPhase();

          // Add border to instructions box
          document.querySelector(".instructions-box").classList.add("border-active");
        case 8:
        case "end":
          return _context.stop();
      }
    }, _callee);
  })));
  document.getElementById('feedbackSubmit').addEventListener('click', /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
    var feedbackText, response, data, recommendationElement;
    return _regeneratorRuntime().wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          feedbackText = document.getElementById('feedbackInput').value;
          if (!feedbackText.trim()) {
            _context2.next = 15;
            break;
          }
          _context2.next = 4;
          return fetch('/feedback', {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json'
            },
            body: JSON.stringify({
              feedback: feedbackText
            })
          });
        case 4:
          response = _context2.sent;
          _context2.next = 7;
          return response.json();
        case 7:
          data = _context2.sent;
          recommendationElement = document.getElementById('recommendation');
          recommendationElement.innerText = data.recommendation;

          // Read the recommendation aloud
          console.log("Speaking recommendation:", data.recommendation);
          speakTextUnified(data.recommendation); // Trigger voice synthesis for the recommendation

          setTimeout(function () {
            console.log("Recommendation shown. Now displaying radio buttons.");
            showRadioButtons();
          }, 0);
          _context2.next = 16;
          break;
        case 15:
          alert("Please enter your feedback.");
        case 16:
        case "end":
          return _context2.stop();
      }
    }, _callee2);
  })));
});

// Initial Mobile Overlay Event Listerner
document.addEventListener("DOMContentLoaded", function () {
  var mobileOverlay = document.getElementById("mobileOverlay");
  if (window.innerWidth <= 768) {
    mobileOverlay.classList.add("show");
    setTimeout(function () {
      mobileOverlay.classList.add("hide");
      setTimeout(function () {
        mobileOverlay.style.display = "none";
      }, 3000); // Matches fade-out duration
    }, 5000 + 3000); // Wait 3s before fade-out
  }
});

// Toggle pause state on button click
document.addEventListener('DOMContentLoaded', function () {
  var pauseButton = document.getElementById('pauseButton');
  if (pauseButton) {
    pauseButton.addEventListener('click', function () {
      isPaused = !isPaused; // Toggle the paused state
      pauseButton.textContent = isPaused ? "Continue" : "Pause"; // Update button text
    });
  } else {
    console.error("Pause button not found in the DOM.");
  }
});
document.addEventListener('DOMContentLoaded', function () {
  var phaseToggle = document.getElementById('phaseToggle');
  var phaseOverlay = document.getElementById('phaseOverlay');
  var closePhase = document.getElementById('closePhase');
  var phaseList = document.getElementById('phaseList');
  var phaseColumn = document.getElementById('phaseColumn');

  // Phase titles
  var phases = ["INTRODUCTION", "FLOW RHYTHM", "RESOURCE STATE I", "DECOMPRESSION RHYTHM", "RESOURCE STATE II", "FREEZING", "DECOMPRESSION PROCESS", "RESOURCE STATE II", "RESOURCE RHYTHM", "RESOURCE STATE I", "RESOURCE STATE II", "RESOURCE-RHYTHM AND REENTERING INTO HERE AND NOW", "CLOSING STATEMENT", "CONCLUSION"];

  // Function to populate phase rows for BOTH desktop and overlay
  function populatePhaseLists() {
    phaseColumn.innerHTML = ''; // Clear desktop list
    phaseList.innerHTML = ''; // Clear overlay list

    phases.forEach(function (phase, index) {
      // Create desktop phase row
      var desktopRow = document.createElement('div');
      desktopRow.classList.add('phase-row');
      desktopRow.textContent = phase;
      desktopRow.dataset.phaseIndex = index;
      phaseColumn.appendChild(desktopRow);

      // Create overlay phase row (pre-created but hidden)
      var overlayRow = document.createElement('div');
      overlayRow.classList.add('phase-row');
      overlayRow.textContent = phase;
      overlayRow.dataset.phaseIndex = index;
      phaseList.appendChild(overlayRow);
    });
    console.log("✅ Phase lists populated for desktop and overlay");
  }

  // Populate the phase lists on page load
  populatePhaseLists();

  // Open overlay when clicking 'Show Phase Guide'
  phaseToggle.addEventListener('click', function () {
    phaseOverlay.classList.add('active'); // Show overlay

    // Ensure the correct phase is highlighted
    var currentPhaseIndex = getCurrentPhaseIndex(); // Function to get current phase
    activatePhase(currentPhaseIndex);
  });

  // Close overlay when clicking '×'
  closePhase.addEventListener('click', function () {
    phaseOverlay.classList.remove('active'); // Hide overlay
  });
});

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _script_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./script.js */ "./src/script.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
// import { ElevenLabsClient, play } from "elevenlabs";
// const elevenlabs = new ElevenLabsClient({
//    apiKey: "sk_b66b0f0cc68730f7a184ff4543a96e62d83be7ab4b9ebdc7",  // Replace with your ElevenLabs API key
// });
// Define the speakTextUnified function using fetch
// async function speakTextUnified(text, voiceId = "oWAxZDx7w5VEj9dCyTzz") {
// async function speakTextUnified(text, voiceId = "JBFqnCBsd6RMkjVDRZzb") {  // George

 // imports the Javascript of the online app which was prior in index.html directly

 // Import AudioContext-based playback
function speakTextUnified(_x) {
  return _speakTextUnified.apply(this, arguments);
} // Export the function to make it available globally
function _speakTextUnified() {
  _speakTextUnified = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(text) {
    var voiceId,
      apiKey,
      url,
      response,
      audioBlob,
      audioUrl,
      audio,
      _args = arguments;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          voiceId = _args.length > 1 && _args[1] !== undefined ? _args[1] : "GXNIlNdiZ66cesbId98C";
          // Jörg
          // JBFqnCBsd6RMkjVDRZzb   George
          // GXNIlNdiZ66cesbId98C   Jörg
          console.log("executing function speakTextUnified:", text);
          apiKey = "sk_b66b0f0cc68730f7a184ff4543a96e62d83be7ab4b9ebdc7"; // Replace with your ElevenLabs API key
          url = "https://api.elevenlabs.io/v1/text-to-speech/".concat(voiceId);
          _context.prev = 4;
          _context.next = 7;
          return fetch(url, {
            method: "POST",
            headers: {
              "Content-Type": "application/json",
              "xi-api-key": apiKey // API key in the header
            },
            body: JSON.stringify({
              text: text,
              model_id: "eleven_multilingual_v2" // Adjust model ID if needed  model_id: "eleven_multilingual_v2"
            })
          });
        case 7:
          response = _context.sent;
          if (response.ok) {
            _context.next = 10;
            break;
          }
          throw new Error("HTTP error! status: ".concat(response.status));
        case 10:
          _context.next = 12;
          return response.blob();
        case 12:
          audioBlob = _context.sent;
          audioUrl = URL.createObjectURL(audioBlob);
          if (!(0,_script_js__WEBPACK_IMPORTED_MODULE_0__.isMobileDevice)()) {
            _context.next = 19;
            break;
          }
          _context.next = 17;
          return (0,_script_js__WEBPACK_IMPORTED_MODULE_0__.playAudioBlob)(audioBlob);
        case 17:
          _context.next = 21;
          break;
        case 19:
          // 🔹 Use Standard Audio Playback for Desktop
          audio = new Audio(audioUrl);
          return _context.abrupt("return", new Promise(function (resolve, reject) {
            audio.onended = resolve;
            audio.onerror = reject;
            audio.play()["catch"](function (err) {
              return console.error("Desktop playback failed:", err);
            });
          }));
        case 21:
          _context.next = 34;
          break;
        case 23:
          _context.prev = 23;
          _context.t0 = _context["catch"](4);
          console.error("Error with ElevenLabs TTS:", _context.t0);
          if (!_context.t0.response) {
            _context.next = 33;
            break;
          }
          console.error("Response status:", _context.t0.response.status);
          _context.t1 = console;
          _context.next = 31;
          return _context.t0.response.text();
        case 31:
          _context.t2 = _context.sent;
          _context.t1.error.call(_context.t1, "Response body:", _context.t2);
        case 33:
          throw _context.t0;
        case 34:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[4, 23]]);
  }));
  return _speakTextUnified.apply(this, arguments);
}
window.speakTextUnified = speakTextUnified;
})();

/******/ })()
;
//# sourceMappingURL=bundle.js.map