    let voices = []; // Global variable to store available voices
    let isPaused = false; // Global flag for pause state
    // === Initialize Audio Context (Global) ===
    let audioContext = null;

// Array of phase titles
const phases = [
    "INTRODUCTION", "FLOW RHYTHM", "RESOURCE STATE I", "DECOMPRESSION RHYTHM",
    "RESOURCE STATE II", "FREEZING", "DECOMPRESSION PROCESS", "RESOURCE STATE II",
    "RESOURCE RHYTM", "RESOURCE STATE I", "RESOURCE STATE II", "RESOURCE-RHYTHM AND REENTERING INTO HERE AND NOW",
    "CLOSING STATEMENT", "CONCLUSION"
];


export function isMobileDevice() {
    return /Mobi|Android|iPhone|iPad|iPod/i.test(navigator.userAgent);
}

export function logToScreen(message) {
    let logDiv = document.getElementById("log");
    if (!logDiv) {
        logDiv = document.createElement("div");
        logDiv.id = "log";
        logDiv.style = "position:fixed;bottom:0;left:0;width:100%;height:150px;background:white;overflow:auto;font-size:14px;z-index:9999;padding:10px;border-top:1px solid black;";
        document.body.appendChild(logDiv);
    }
    logDiv.innerHTML += `<div>${message}</div>`;
}


function unlockAudio() {
    const unlock = new Audio();
    unlock.src = "data:audio/wav;base64,UklGRiQAAABXQVZFZm10IBAAAAABAAEARKwAABCxAgAEABAAZGF0YQAAAAA="; // Silent WAV
    unlock.play()
        // .then(() => logToScreen("Unlock audio success!"))
        // .catch(e => logToScreen("Unlock audio failed: " + e.message));
        .then(() => console.log("Unlock audio success!"))
        .catch(e => console.log("Unlock audio failed: " + e.message));
}

export function initializeAudioContext() {
    if (!audioContext) {
        audioContext = new (window.AudioContext || window.webkitAudioContext)();
        // logToScreen("AudioContext created.");
        console.log("AudioContext created.");
    }
    if (audioContext.state === "suspended") {
        // audioContext.resume().then(() => logToScreen("AudioContext resumed."));
        audioContext.resume().then(() => console.log("AudioContext resumed."));
    }
}


// === Function to Play Audio Using AudioContext ===
export async function playAudioBlob(audioBlob) {
    return new Promise(async (resolve, reject) => {
        try {
            
            const arrayBuffer = await audioBlob.arrayBuffer();
            const audioBuffer = await audioContext.decodeAudioData(arrayBuffer);

            const source = audioContext.createBufferSource();
            source.buffer = audioBuffer;
            source.connect(audioContext.destination);
            
            // source.onended = () => resolve();
            source.onended = () => {
                console.log("Audio playback finished.");
                // logToScreen("Audio playback finished.");
                resolve();
            };
            source.start(0);
            console.log("Audio playback started.");
            // logToScreen("Audio playback started.");
        } catch (error) {
            console.log("Error during playback: " + error.message);
            // logToScreen("Error during playback: " + error.message);
            reject(error);
        }
    });
}

function populatePhaseColumn() {
    const phaseColumn = document.getElementById('phaseColumn');
    phases.forEach((phase, index) => {
        const row = document.createElement('div');
        row.classList.add('phase-row');
        row.textContent = phase;
        row.dataset.phaseIndex = index;
        phaseColumn.appendChild(row);
    });
}

function activatePhaseAAAA(phaseIndex) {
    const phaseRows = document.querySelectorAll('.phase-row');
    phaseRows.forEach(row => row.classList.remove('active'));
    const activeRow = document.querySelector(`.phase-row[data-phase-index="${phaseIndex}"]`);
    if (activeRow) {
        activeRow.classList.add('active');
    }
}

function activatePhaseBBBBB(phaseIndex) {
    // Target normal phase rows (desktop mode)
    const phaseRows = document.querySelectorAll('.phase-row');
    phaseRows.forEach(row => row.classList.remove('active'));

    const activeRow = document.querySelector(`.phase-row[data-phase-index="${phaseIndex}"]`);
    if (activeRow) {
        activeRow.classList.add('active');
    }

    // Target overlay phase rows (when overlay is open)
    const phaseOverlay = document.getElementById('phaseOverlay');
    if (phaseOverlay && phaseOverlay.style.display !== 'none') { // Ensure overlay is visible
        const overlayRows = phaseOverlay.querySelectorAll('.phaseOverlayRow');
        overlayRows.forEach(row => row.classList.remove('active'));

        const activeOverlayRow = phaseOverlay.querySelector(`.phaseOverlayRow[data-phase-index="${phaseIndex}"]`);
        if (activeOverlayRow) {
            activeOverlayRow.classList.add('active');
        }
    }
}

function activatePhase(phaseIndex) {
    // Handle desktop phase rows inside #phaseColumn
    document.querySelectorAll('#phaseColumn .phase-row').forEach(row => row.classList.remove('active'));
    const activeRow = document.querySelector(`#phaseColumn .phase-row[data-phase-index="${phaseIndex}"]`);
    if (activeRow) {
        activeRow.classList.add('active');
    }

    // Handle mobile overlay phase rows inside #phaseList
    document.querySelectorAll('#phaseList .phase-row').forEach(row => row.classList.remove('active'));
    const activeOverlayRow = document.querySelector(`#phaseList .phase-row[data-phase-index="${phaseIndex}"]`);
    if (activeOverlayRow) {
        activeOverlayRow.classList.add('active');
        console.log("Activated phase in overlay:", activeOverlayRow);
    }
}


// Call this function once to populate the phase column on load
document.addEventListener('DOMContentLoaded', populatePhaseColumn);


// Example call to activate the phase, can be called within getNextPhase or displayInstructions
activatePhase(0); // Set initial phase as active


    // Function to clear feedback and recommendation sections
    function clearFeedbackAndRecommendation() {
        document.getElementById('feedbackInput').value = ''; // Clear feedback input
        document.getElementById('recommendation').innerText = ''; // Clear recommendation display
    }

    // Function to clear the radio buttons and feedback box immediately after selection
    function clearFeedbackAndRadioButtons() {
        document.getElementById('feedbackBox').style.display = 'none';  // Hide feedback box
        document.getElementById('questions').style.display = 'none';    // Hide radio buttons
        document.getElementById('questions').innerHTML = '';            // Clear radio buttons content
    }


    function stopSpeech() {
        if (window.speechSynthesis.speaking || window.speechSynthesis.pending) {
            window.speechSynthesis.cancel();
        }
    }



// Dummy function for testing that does nothing
function speakText(text, voiceName = 'Aaron') {
    // Intentionally left blank to bypass voice output
}


function speakTextAfterVoicesLoaded(text, voiceName = 'Aaron') {
    console.log("Opening function speakTextAfterVoicesLoaded:", text);
    if (typeof text !== 'string') {
        console.log("Non-string input detected in speakTextAfterVoicesLoaded:", text);
        return;  // Exit if the input is not a string
    }

    // Wait for voices to load if they haven't yet
    if (voices.length === 0) {
        setTimeout(() => speakTextAfterVoicesLoaded(text, voiceName), 100);
    } else {
        speakTextUnified(text, voiceName);  // Pass both text and voiceName to speakText
    }
}


function scrollToBottom() {
    let box = document.querySelector('.instructions-box');
    if (box) {
        requestAnimationFrame(() => {
            box.scrollTop = box.scrollHeight;
            console.log("🔽 Forced Scroll:", box.scrollTop, "/", box.scrollHeight);
        });
    }
}


function scrollToBottomZZZZZ() {
    let box = document.querySelector('.instructions-box');
    if (box) {
        setTimeout(() => {
            box.scrollTop = box.scrollHeight;
            console.log("🔽 Forced Scroll:", box.scrollTop, "/", box.scrollHeight);
        }, 0); // Ensures scrolling happens after content updates
    }
}


function typeText(element, html, letterDelay) {
    return new Promise((resolve) => {
        let currentIndex = 0;
        let box = document.querySelector('.instructions-box');

        function typeNextLetter() {
            if (currentIndex < html.length) {
                if (html[currentIndex] === '<') {
                    const closingTagIndex = html.indexOf('>', currentIndex) + 1;
                    element.innerHTML += html.slice(currentIndex, closingTagIndex);
                    currentIndex = closingTagIndex;
                } else {
                    element.innerHTML += html[currentIndex];
                    currentIndex++;
                }

                // Call scrolling function to keep text in view
                requestAnimationFrame(scrollToBottom);

                setTimeout(typeNextLetter, letterDelay);
            } else {
                resolve();
            }
        }

        typeNextLetter();
    });
}


function typeTextZZZZZ(element, html, letterDelay) {
    return new Promise((resolve) => {
        let currentIndex = 0;
        let box = document.querySelector('.instructions-box');

        function typeNextLetter() {
            if (currentIndex < html.length) {
                if (html[currentIndex] === '<') {
                    const closingTagIndex = html.indexOf('>', currentIndex) + 1;
                    element.innerHTML += html.slice(currentIndex, closingTagIndex);
                    currentIndex = closingTagIndex;
                } else {
                    element.innerHTML += html[currentIndex];
                    currentIndex++;
                }

                // Scroll after adding each letter
                requestAnimationFrame(scrollToBottom);

                setTimeout(typeNextLetter, letterDelay);
            } else {
                resolve();
            }
        }

        typeNextLetter();
    });
}

function typeTextFFFFFFF(element, html, letterDelay) {
    return new Promise((resolve) => {
        let currentIndex = 0;
        let box = document.querySelector('.instructions-box');

        function typeNextLetter() {
            if (currentIndex < html.length) {
                if (html[currentIndex] === '<') {
                    const closingTagIndex = html.indexOf('>', currentIndex) + 1;
                    element.innerHTML += html.slice(currentIndex, closingTagIndex);
                    currentIndex = closingTagIndex;
                } else {
                    element.innerHTML += html[currentIndex];
                    currentIndex++;
                }

                // Scroll to the bottom smoothly as text appears
                if (box) {
                    box.scrollTop = box.scrollHeight;
                }

                setTimeout(typeNextLetter, letterDelay);
            } else {
                resolve();
            }
        }

        typeNextLetter();
    });
}


    function typeTextDDDDD(element, html, letterDelay) {
        return new Promise((resolve) => {
            let currentIndex = 0;

            function typeNextLetter() {
                if (currentIndex < html.length) {
                    if (html[currentIndex] === '<') {
                        const closingTagIndex = html.indexOf('>', currentIndex) + 1;
                        element.innerHTML += html.slice(currentIndex, closingTagIndex);
                        currentIndex = closingTagIndex;
                    } else {
                        element.innerHTML += html[currentIndex];
                        currentIndex++;
                    }
                    setTimeout(typeNextLetter, letterDelay);
                } else {
                    resolve();
                }
            }

            typeNextLetter();
        });
    }


function formatText(text) {
    console.log("Original text:", text); // Log original text for debugging

    // Handle <bold> and <big> custom tags
    text = text
        .replace(/<bold>(.*?)<\/bold>/g, '<span class="bold-text">$1</span>')
        .replace(/<big>(.*?)<\/big>/g, '<span class="big-text">$1</span>')
        .replace(/<bold,\s?big>(.*?)<\/bold,\s?\/big>/g, '<span class="bold-big-text">$1</span>');

    // Ensure the closing tags are properly applied for <bold, big>
    text = text.replace(/<\/bold,\s?\/big>/g, '</span>');

    // Handle <problem> tag (if it needs to be removed or styled differently)
    text = text.replace(/<problem>/g, '').replace(/<\/problem>/g, '');

    // Keep (A), (B), (C), and (Z) intact by NOT modifying anything inside parentheses
    text = text.replace(/-\s([A-Z]\))\s+/g, function(match, p1) {
        return `<span class="bold-text">${p1.trim()}</span>`;
    });

    console.log("After replacing custom tags:", text); // Log the text after replacing custom tags

    return text;
}

function playSound(filename) {
    return new Promise((resolve, reject) => {
        const audioElement = new Audio(`/static/${filename}.mp4`);
        
        // Resolve the promise when the sound finishes
        audioElement.onended = () => {
            console.log(`Sound ${filename} finished playing.`);
            resolve();
        };

        // Reject if there's an error
        audioElement.onerror = (error) => {
            console.error(`Error playing sound ${filename}:`, error);
            reject(error);
        };

        audioElement.play().catch(error => {
            console.error(`Play error for ${filename}:`, error);
            resolve(); // Resolve even on error to prevent blocking
        });
    });
}


async function displayGoodbyeInstructions(segmentedInstructions) {
    console.log("Show Segmented Good Bye Instructions:", segmentedInstructions);
    const instructionsDiv = document.getElementById('instructions');
    instructionsDiv.innerHTML = ''; // Clear previous instructions

    for (const segment of segmentedInstructions) {
        if (segment.type === "sound") {
            // Play sound and wait for it to finish
            const soundFile = segment.value;
            console.log("Playing sound file:", soundFile);
            await playSound(soundFile); // Wait until sound completes
        } else if (segment.type === "text") {
            // Split the text segment into lines based on line breaks
            const lines = segment.value.split('\n');

            for (const line of lines) {
                if (line.trim() === '') continue; // Skip empty lines

                // Display the line
                const goodbyeParagraph = document.createElement('p');
                goodbyeParagraph.id = 'goodbyeParagraph';
                instructionsDiv.appendChild(goodbyeParagraph);
                await typeText(goodbyeParagraph, line.trim(), 10);  // Display line gradually
                goodbyeParagraph.style.display = 'flex';
                // Log and wait for speech synthesis of this line to finish
                // console.log("Speaking line:", line.trim());  // Debugging line
                await speakTextUnified(line.trim());
            }
        }
    }

    // Call showFeedbackAndQuestions once all segments are processed
    // showFeedbackAndQuestions();
}

//
//function scrollToBottom() {
//    var box = document.querySelector('.instructions-box');
//    if (box) {
//        box.scrollTop = box.scrollHeight;
//    }
//}


async function displayInstructions(segmentedInstructions) {
    console.log("Show Segmented Instructions:", segmentedInstructions);
    const instructionsDiv = document.getElementById('instructions');
    const pauseButton = document.getElementById('pauseButton');

    // Show the pause button when the loop starts
    if (pauseButton) pauseButton.style.display = 'block';

    instructionsDiv.innerHTML = ''; // Clear previous instructions

    for (const segment of segmentedInstructions) {
        if (segment.type === "sound") {
            const soundFile = segment.value;
            console.log("Playing sound file:", soundFile);
            await playSound(soundFile); // Wait until sound completes
        } else if (segment.type === "text") {
            const lines = segment.value.split('\n');

            for (const line of lines) {
                if (line.trim() === '') continue; // Skip empty lines

                while (isPaused) {
                    console.log("Paused... waiting to continue.");
                    await new Promise(resolve => setTimeout(resolve, 100)); // Wait while paused
                }

                const waitMatch = line.match(/<wait:(\d+)>/);
                if (waitMatch) {
                    const waitTime = parseInt(waitMatch[1], 10);
                    console.log(`Waiting for ${waitTime} milliseconds...`);
                    await new Promise(resolve => setTimeout(resolve, waitTime));
                    continue;
                }

                const paragraph = document.createElement('p');
                instructionsDiv.appendChild(paragraph);
                await typeText(paragraph, line.trim(), 10); // Display line gradually

                console.log("Speaking line:", line.trim());
                await speakTextUnified(line.trim());  // the real thing
            }
        }
    }

    // Hide the pause button when the loop ends
    if (pauseButton) pauseButton.style.display = 'none';

    // showFeedbackAndQuestions();
}

async function displayQuestions(questions) {
    const questionContainer = document.getElementById('questions');
    console.log('call displayQuestions with questionContainer:', questionContainer);
    questionContainer.innerHTML = ''; // Clear previous questions

    const form = document.createElement('form');
    form.style.flexDirection = 'column';

    let aiTriggered = false; // Track if the AI-triggering question is present

    questions.forEach((question, index) => {
        const label = document.createElement('label');
        const radio = document.createElement('input');
        radio.type = 'radio';
        radio.name = 'choice';
        radio.value = question.choice;

        const cleanText = question.text.replace(/\([A-Z]\)\s*/, ''); // Clean up choice text
        label.innerHTML = cleanText;
        label.prepend(radio);

        form.appendChild(label);

        // Check if the question is a (Z)-triggered question
        if (question.text.includes("(Z)")) {
            aiTriggered = true;
            label.innerHTML += " (Requires AI input)";
            radio.addEventListener('change', () => {
                showOpenAIInputField(); // Trigger OpenAI input field
            });
        }

        if (index === 0) {
            radio.checked = true;
        }
    });

    const submitButton = document.createElement('button');
    submitButton.type = 'button';
    submitButton.id = 'submitButton';
    submitButton.className = 'button-custom';
    submitButton.innerText = 'Submit';
    submitButton.onclick = function () {
        const selectedChoice = form.querySelector('input[name="choice"]:checked');
        if (selectedChoice) {
            if (aiTriggered && selectedChoice.value === "(Z)") {
                handleOpenAIInput(); // Handle AI-specific input
            } else {
                console.log('Clearing Radio-Buttons after Submit, in case selectedChoice:', selectedChoice);
                clearFeedbackAndRadioButtons(); // Clear previous feedback and radio buttons
                console.log('call getNextPhase with selected choice:', selectedChoice.value);
                getNextPhase(selectedChoice.value);
            }
        } else {
            alert('Please select an option.');
        }
    };

    form.appendChild(submitButton);
    questionContainer.appendChild(form);

    // Show questions container
    showRadioButtons();

    // Ensure the AI input field is shown if (Z) question is selected by default
    if (aiTriggered) {
        showOpenAIInputField();
    }
}


// Function to display the OpenAI input box
function showOpenAIInputField() {
    const openAIInput = document.createElement('textarea');
    openAIInput.id = 'openAIInput';
    openAIInput.placeholder = 'Please provide your input for AI...';
    openAIInput.style.width = '100%';
    openAIInput.style.height = '100px';

    // Append the input field under the questions
    document.getElementById('questions').appendChild(openAIInput);
}


async function handleOpenAIInput() {
    console.log("Start HandleOpenAIInput");
    const aiInput = document.getElementById('openAIInput');
    if (aiInput && aiInput.value.trim()) {
        console.log('Sending input to OpenAI:', aiInput.value);

        try {
            const response = await fetch('/api/openai', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ prompt: aiInput.value })
            });

            const data = await response.json();

            const recommendationElement = document.getElementById('recommendation');
            recommendationElement.innerText = data.output;

            console.log("Speaking OpenAI output:", data.output);
            await speakTextUnified(data.output); // Ensure AI output is spoken sequentially

            // Clear fields and move to the next phase
            console.log("Clearing Radio-Buttons after AI Output");
            clearFeedbackAndRadioButtons();
        } catch (error) {
            console.error('Error with OpenAI API:', error);
        }
    } else {
        alert('Please provide your input for AI.');
    }
}

    function hideRadioButtons() {
        document.getElementById('questions').style.display = 'none';
    }

    function showRadioButtons() {
        document.getElementById('questions').style.display = 'flex';
    }


async function showFeedbackAndQuestions(phase) {
    console.log(`[${new Date().toISOString()}] showFeedbackAndQuestions called with phase: ${phase}`);

    const feedbackBox = document.getElementById('feedbackBox');
    feedbackBox.style.display = 'flex'; // Show feedback box
    const feedbackInput = document.getElementById('feedbackInput');
    const feedbackLabel = document.querySelector('label[for="feedbackInput"]');

    if (phase === 1) {
        console.log(`[${new Date().toISOString()}] Executing phase 1 one block`);
        feedbackLabel.textContent = "How does this sound to you? Shall we start? You can also ask me any question about the process.";
        await speakTextUnified(feedbackLabel.textContent); // Await speech for phase 1
    } else {
        console.log(`[${new Date().toISOString()}] Executing else 1 one block`);
        feedbackLabel.textContent = "How did the last part of the session work for you?";
        await speakTextUnified(feedbackLabel.textContent); // Await speech for other phases
    }

    setTimeout(() => {
        feedbackInput.focus();
        console.log(`[${new Date().toISOString()}] Attempting to focus feedback input`);

        if (document.activeElement === feedbackInput) {
            console.log('Feedback input is focused');
        } else {
            console.log('Focus failed on feedback input');
        }
    }, 100); // Delay to ensure rendering
}



async function getNextPhase(choice = "A") {
    try {
        clearFeedbackAndRecommendation(); // Clear previous feedback and recommendation

        const response = await fetch('/next-phase', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ choice: choice })
        });

        if (!response.ok) {
            throw new Error('Bad Request: ' + response.statusText);
        }

        const data = await response.json();
        console.log('Phase received:', data.phase);
        console.log('Instructions received:', data.segmentedInstructions);

        // Highlight the active phase using data.phase
        activatePhase(data.phase - 1);

        if (! data.is_last_phase) {
            await displayInstructions(data.segmentedInstructions || 'No instructions received', data.soundFiles || []);
            // speakTextAfterVoicesLoaded(data.segmentedInstructions || 'No instructions received');
            await displayQuestions(data.questions || []);
            // Hide radio buttons
            hideRadioButtons();

            // Show feedback box and update label based on phase
            console.log("Calling showFeedbackAndQuestions:", data.phase);
            showFeedbackAndQuestions(data.phase);  // Pass the current phase to the function

            } else {
              await displayGoodbyeInstructions(data.segmentedInstructions || 'No instructions received', data.soundFiles || []);
              //speakTextAfterVoicesLoaded(data.segmentedInstructions || 'No instructions received');
              feedbackBox.style.display = 'none';  // Do not show feedback box
              // await displayQuestions(data.questions || []);
            }

    } catch (error) {
        console.error("Error fetching the next phase:", error);
    }
}

    async function resetPhase() {
        try {
            const response = await fetch('/reset-phase', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                }
            });

            if (!response.ok) {
                throw new Error('Failed to reset phase: ' + response.statusText);
            }

            const data = await response.json();
            console.log(data.message);
        } catch (error) {
            console.error("Error resetting phase:", error);
        }
    }

function showGoodbyeMessage(goodbyeText) {
    // Clear all dynamic content from the content area
    const contentArea = document.getElementById('contentArea');
    contentArea.innerHTML = ''; // Clear all previous content

    // Create the goodbye message element
    const goodbyeMessage = document.createElement('div');
    goodbyeMessage.id = 'goodbyeMessage';
    goodbyeMessage.textContent = goodbyeText; // Set the text from the last phase

    // Append the goodbye message to the content area
    contentArea.appendChild(goodbyeMessage);

    // Apply the display style to show the goodbye message
    goodbyeMessage.style.display = 'flex';
}

async function handleEndOfProcess() {
    try {
        // Fetch the instructions for the last phase
        const response = await fetch('/next-phase', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ choice: "A" }) // Adjust as necessary to indicate the end phase
        });

        if (!response.ok) {
            throw new Error('Failed to fetch the last phase: ' + response.statusText);
        }

        const data = await response.json();
        const goodbyeInstructions = data.instructions || "Thank you for participating."; // Default if no instructions

        // Display the goodbye message with the last phase's instructions
        showGoodbyeMessage(goodbyeInstructions);
    } catch (error) {
        console.error("Error handling the end of the process:", error);
    }
}

    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('button-start').addEventListener('click', async function() {

            initializeAudioContext(); // Unlock AudioContext inside user interaction
            unlockAudio(); // Play silent audio inside user gesture

            await resetPhase();

            document.getElementById('button-start').style.display = 'none';
            hideRadioButtons();
            getNextPhase();

        });

        document.getElementById('feedbackSubmit').addEventListener('click', async function() {
            const feedbackText = document.getElementById('feedbackInput').value;
            if (feedbackText.trim()) {
                const response = await fetch('/feedback', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ feedback: feedbackText })
                });

                const data = await response.json();

                const recommendationElement = document.getElementById('recommendation');
                recommendationElement.innerText = data.recommendation;

                // Read the recommendation aloud
                console.log("Speaking recommendation:", data.recommendation);
                speakTextUnified(data.recommendation); // Trigger voice synthesis for the recommendation

                setTimeout(() => {
                    console.log("Recommendation shown. Now displaying radio buttons.");
                    showRadioButtons();
                }, 0);
            } else {
                alert("Please enter your feedback.");
            }
        });
    });

// Toggle pause state on button click
document.addEventListener('DOMContentLoaded', () => {
    const pauseButton = document.getElementById('pauseButton');
    if (pauseButton) {
        pauseButton.addEventListener('click', () => {
            isPaused = !isPaused; // Toggle the paused state
            pauseButton.textContent = isPaused ? "Continue" : "Pause"; // Update button text
        });
    } else {
        console.error("Pause button not found in the DOM.");
    }
});

document.addEventListener('DOMContentLoaded', function() {
    const phaseToggle = document.getElementById('phaseToggle');
    const phaseOverlay = document.getElementById('phaseOverlay');
    const closePhase = document.getElementById('closePhase');
    const phaseList = document.getElementById('phaseList');

    // Function to populate the phase overlay
    function populatePhaseOverlay() {
        phaseList.innerHTML = ''; // Clear existing entries
        const phases = [
            "INTRODUCTION", "FLOW RHYTHM", "RESOURCE STATE I", "DECOMPRESSION RHYTHM",
            "RESOURCE STATE II", "FREEZING", "DECOMPRESSION PROCESS", "RESOURCE STATE II",
            "RESOURCE RHYTHM", "RESOURCE STATE I", "RESOURCE STATE II", "RESOURCE-RHYTHM AND REENTERING INTO HERE AND NOW",
            "CLOSING STATEMENT", "CONCLUSION"
        ];
        
        phases.forEach((phase, index) => {
            const row = document.createElement('div');
            row.classList.add('phase-row');
            row.textContent = phase;
            row.dataset.phaseIndex = index;
            phaseList.appendChild(row);
        });
    }

    // Open overlay when clicking 'Current Phase'
    // phaseToggle.addEventListener('click', function() {
    //    populatePhaseOverlay();
    //    phaseOverlay.classList.add('active');
    //});

    // Open overlay when clicking 'Current Phase'

    // Open overlay when clicking 'Show Phase Guide'
    phaseToggle.addEventListener('click', function() {
        populatePhaseOverlay(); // Regenerate the list every time
        phaseOverlay.classList.add('active'); // Show overlay

        // Ensure the correct phase is highlighted in the overlay
        setTimeout(() => {
            const currentPhaseIndex = getCurrentPhaseIndex(); // Assume this function gets the current phase
            activatePhase(currentPhaseIndex);
        }, 100); // Small delay ensures DOM is updated
    });

    // Close overlay when clicking '×'
    closePhase.addEventListener('click', function() {
        phaseOverlay.classList.remove('active');
    });
});

