// import { ElevenLabsClient, play } from "elevenlabs";
// const elevenlabs = new ElevenLabsClient({
//    apiKey: "sk_b66b0f0cc68730f7a184ff4543a96e62d83be7ab4b9ebdc7",  // Replace with your ElevenLabs API key
// });
// Define the speakTextUnified function using fetch
// async function speakTextUnified(text, voiceId = "oWAxZDx7w5VEj9dCyTzz") {
// async function speakTextUnified(text, voiceId = "JBFqnCBsd6RMkjVDRZzb") {  // George

import "./script.js"; // imports the Javascript of the online app which was prior in index.html directly
import { isMobileDevice } from "./script.js";
import { playAudioBlob } from "./script.js"; // Import AudioContext-based playback

async function speakTextUnified(text, voiceId = "GXNIlNdiZ66cesbId98C") {  // Jörg
    // JBFqnCBsd6RMkjVDRZzb   George
    // GXNIlNdiZ66cesbId98C   Jörg
    console.log("executing function speakTextUnified:", text);

    const apiKey = "sk_b66b0f0cc68730f7a184ff4543a96e62d83be7ab4b9ebdc7"; // Replace with your ElevenLabs API key
    const url = `https://api.elevenlabs.io/v1/text-to-speech/${voiceId}`;

    try {
        const response = await fetch(url, {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "xi-api-key": apiKey, // API key in the header
            },
            body: JSON.stringify({
                text: text,
                model_id: "eleven_multilingual_v2", // Adjust model ID if needed  model_id: "eleven_multilingual_v2"
            }),
        });

        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }

        const audioBlob = await response.blob();
        const audioUrl = URL.createObjectURL(audioBlob);

        if (isMobileDevice()) {

	// 🔹 Use AudioContext for Mobile Browsers
            await playAudioBlob(audioBlob);

	} else {

            // 🔹 Use Standard Audio Playback for Desktop
            const audio = new Audio(audioUrl);
            return new Promise((resolve, reject) => {
                audio.onended = resolve;
                audio.onerror = reject;
                audio.play().catch(err => console.error("Desktop playback failed:", err));
            });

      }
    } catch (error) {
        console.error("Error with ElevenLabs TTS:", error);
 	if (error.response) {
        console.error("Response status:", error.response.status);
        console.error("Response body:", await error.response.text());
    	}
        throw error; // Ensure the error propagates to the caller
    }
}

// Export the function to make it available globally
window.speakTextUnified = speakTextUnified;
