/**
 * This file was auto-generated by Fern from our API Definition.
 */
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
export declare namespace Voices {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
/**
 * Access to voices created either by you or us.
 */
export declare class Voices {
    protected readonly _options: Voices.Options;
    constructor(_options?: Voices.Options);
    /**
     * Gets a list of all available voices for a user.
     *
     * @param {ElevenLabs.VoicesGetAllRequest} request
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.getAll()
     */
    getAll(request?: ElevenLabs.VoicesGetAllRequest, requestOptions?: Voices.RequestOptions): Promise<ElevenLabs.GetVoicesResponse>;
    /**
     * Gets the default settings for voices. "similarity_boost" corresponds to"Clarity + Similarity Enhancement" in the web app and "stability" corresponds to "Stability" slider in the web app.
     *
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @example
     *     await client.voices.getDefaultSettings()
     */
    getDefaultSettings(requestOptions?: Voices.RequestOptions): Promise<ElevenLabs.VoiceSettings>;
    /**
     * Returns the settings for a specific voice. "similarity_boost" corresponds to"Clarity + Similarity Enhancement" in the web app and "stability" corresponds to "Stability" slider in the web app.
     *
     * @param {string} voiceId - Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.getSettings("2EiwWnXFnvU5JabPnv8n")
     */
    getSettings(voiceId: string, requestOptions?: Voices.RequestOptions): Promise<ElevenLabs.VoiceSettings>;
    /**
     * Returns metadata about a specific voice.
     *
     * @param {string} voiceId - Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     * @param {ElevenLabs.VoicesGetRequest} request
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.get("29vD33N1CtxCmqQRPOHJ")
     */
    get(voiceId: string, request?: ElevenLabs.VoicesGetRequest, requestOptions?: Voices.RequestOptions): Promise<ElevenLabs.Voice>;
    /**
     * Deletes a voice by its ID.
     *
     * @param {string} voiceId - Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.delete("29vD33N1CtxCmqQRPOHJ")
     */
    delete(voiceId: string, requestOptions?: Voices.RequestOptions): Promise<unknown>;
    /**
     * Edit your settings for a specific voice. "similarity_boost" corresponds to"Clarity + Similarity Enhancement" in the web app and "stability" corresponds to "Stability" slider in the web app.
     *
     * @param {string} voiceId - Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     * @param {ElevenLabs.VoiceSettings} request
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.editSettings("29vD33N1CtxCmqQRPOHJ", {
     *         stability: 0.1,
     *         similarity_boost: 0.3,
     *         style: 0.2
     *     })
     */
    editSettings(voiceId: string, request: ElevenLabs.VoiceSettings, requestOptions?: Voices.RequestOptions): Promise<unknown>;
    /**
     * Add a new voice to your collection of voices in VoiceLab.
     *
     * @param {ElevenLabs.BodyAddVoiceV1VoicesAddPost} request
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.add({
     *         files: [fs.createReadStream("/path/to/your/file")],
     *         name: "Alex"
     *     })
     */
    add(request: ElevenLabs.BodyAddVoiceV1VoicesAddPost, requestOptions?: Voices.RequestOptions): Promise<ElevenLabs.AddVoiceIvcResponseModel>;
    /**
     * Edit a voice created by you.
     *
     * @param {string} voiceId
     * @param {ElevenLabs.BodyEditVoiceV1VoicesVoiceIdEditPost} request
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.edit("JBFqnCBsd6RMkjVDRZzb", {
     *         name: "George"
     *     })
     */
    edit(voiceId: string, request: ElevenLabs.BodyEditVoiceV1VoicesVoiceIdEditPost, requestOptions?: Voices.RequestOptions): Promise<unknown>;
    /**
     * Add a sharing voice to your collection of voices in VoiceLab.
     *
     * @param {string} publicUserId - Public user ID used to publicly identify ElevenLabs users.
     * @param {string} voiceId - Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     * @param {ElevenLabs.AddSharingVoiceRequest} request
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.addSharingVoice("63e84100a6bf7874ba37a1bab9a31828a379ec94b891b401653b655c5110880f", "sB1b5zUrxQVAFl2PhZFp", {
     *         new_name: "Alita"
     *     })
     */
    addSharingVoice(publicUserId: string, voiceId: string, request: ElevenLabs.AddSharingVoiceRequest, requestOptions?: Voices.RequestOptions): Promise<ElevenLabs.AddVoiceResponseModel>;
    /**
     * Gets a list of shared voices.
     *
     * @param {ElevenLabs.VoicesGetSharedRequest} request
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.getShared({
     *         page_size: 1,
     *         gender: "female",
     *         language: "en"
     *     })
     */
    getShared(request?: ElevenLabs.VoicesGetSharedRequest, requestOptions?: Voices.RequestOptions): Promise<ElevenLabs.GetLibraryVoicesResponse>;
    /**
     * Returns a list of shared voices similar to the provided audio sample. If neither similarity_threshold nor top_k is provided, we will apply default values.
     *
     * @param {ElevenLabs.BodyGetSimilarLibraryVoicesV1SimilarVoicesPost} request
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.getSimilarLibraryVoices({})
     */
    getSimilarLibraryVoices(request: ElevenLabs.BodyGetSimilarLibraryVoicesV1SimilarVoicesPost, requestOptions?: Voices.RequestOptions): Promise<ElevenLabs.GetLibraryVoicesResponse>;
    /**
     * Gets a profile page based on a handle
     *
     * @param {string} handle - Handle for a VA's profile page
     * @param {Voices.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.voices.getAProfilePage("talexgeorge")
     */
    getAProfilePage(handle: string, requestOptions?: Voices.RequestOptions): Promise<ElevenLabs.ProfilePageResponseModel>;
}
