/**
 * This file was auto-generated by Fern from our API Definition.
 */
/// <reference types="node" />
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
import * as stream from "stream";
export declare namespace TextToSpeech {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class TextToSpeech {
    protected readonly _options: TextToSpeech.Options;
    constructor(_options?: TextToSpeech.Options);
    /**
     * Converts text into speech using a voice of your choice and returns audio.
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     */
    convert(voiceId: string, request: ElevenLabs.TextToSpeechRequest, requestOptions?: TextToSpeech.RequestOptions): Promise<stream.Readable>;
    /**
     * Converts text into speech using a voice of your choice and returns JSON containing audio as a base64 encoded string together with information on when which character was spoken.
     *
     * @param {string} voiceId - Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     * @param {ElevenLabs.TextToSpeechWithTimestampsRequest} request
     * @param {TextToSpeech.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.textToSpeech.convertWithTimestamps("21m00Tcm4TlvDq8ikWAM", {
     *         text: "text"
     *     })
     */
    convertWithTimestamps(voiceId: string, request: ElevenLabs.TextToSpeechWithTimestampsRequest, requestOptions?: TextToSpeech.RequestOptions): Promise<unknown>;
    /**
     * Converts text into speech using a voice of your choice and returns audio as an audio stream.
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     */
    convertAsStream(voiceId: string, request: ElevenLabs.StreamTextToSpeechRequest, requestOptions?: TextToSpeech.RequestOptions): Promise<stream.Readable>;
    /**
     * Converts text into speech using a voice of your choice and returns a stream of JSONs containing audio as a base64 encoded string together with information on when which character was spoken.
     *
     * @param {string} voiceId - Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     * @param {ElevenLabs.StreamTextToSpeechWithTimstampsRequest} request
     * @param {TextToSpeech.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.textToSpeech.streamWithTimestamps("21m00Tcm4TlvDq8ikWAM", {
     *         text: "text"
     *     })
     */
    streamWithTimestamps(voiceId: string, request: ElevenLabs.StreamTextToSpeechWithTimstampsRequest, requestOptions?: TextToSpeech.RequestOptions): Promise<void>;
}
