/**
 * This file was auto-generated by Fern from our API Definition.
 */
/// <reference types="node" />
import * as ElevenLabs from "../../../../index";
import * as fs from "fs";
export interface BodySpeechToSpeechStreamingV1SpeechToSpeechVoiceIdStreamPost {
    /**
     * You can turn on latency optimizations at some cost of quality. The best possible final latency varies by model.
     */
    enable_logging?: ElevenLabs.OptimizeStreamingLatency;
    /**
     * The output format of the generated audio.
     */
    optimize_streaming_latency?: ElevenLabs.OutputFormat;
    /**
     * Output format of the generated audio. Must be one of:
     * mp3_22050_32 - output format, mp3 with 22.05kHz sample rate at 32kbps.
     * mp3_44100_32 - output format, mp3 with 44.1kHz sample rate at 32kbps.
     * mp3_44100_64 - output format, mp3 with 44.1kHz sample rate at 64kbps.
     * mp3_44100_96 - output format, mp3 with 44.1kHz sample rate at 96kbps.
     * mp3_44100_128 - default output format, mp3 with 44.1kHz sample rate at 128kbps.
     * mp3_44100_192 - output format, mp3 with 44.1kHz sample rate at 192kbps. Requires you to be subscribed to Creator tier or above.
     * pcm_16000 - PCM format (S16LE) with 16kHz sample rate.
     * pcm_22050 - PCM format (S16LE) with 22.05kHz sample rate.
     * pcm_24000 - PCM format (S16LE) with 24kHz sample rate.
     * pcm_44100 - PCM format (S16LE) with 44.1kHz sample rate. Requires you to be subscribed to Pro tier or above.
     * ulaw_8000 - μ-law format (sometimes written mu-law, often approximated as u-law) with 8kHz sample rate. Note that this format is commonly used for Twilio audio inputs.
     */
    output_format?: string;
    audio: File | fs.ReadStream | Blob;
    /** Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for speech to speech, you can check this using the can_do_voice_conversion property. */
    model_id?: string;
    /** Voice settings overriding stored setttings for the given voice. They are applied only on the given request. Needs to be send as a JSON encoded string. */
    voice_settings?: string;
    /** If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism is not guaranteed. Must be integer between 0 and 4294967295. */
    seed?: number;
    /** If set will remove the background noise from your audio input using our audio isolation model. Only applies to Voice Changer. */
    remove_background_noise?: boolean;
}
