/**
 * This file was auto-generated by Fern from our API Definition.
 */
/// <reference types="node" />
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
import * as stream from "stream";
export declare namespace SpeechToSpeech {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class SpeechToSpeech {
    protected readonly _options: SpeechToSpeech.Options;
    constructor(_options?: SpeechToSpeech.Options);
    /**
     * Create speech by combining the content and emotion of the uploaded audio with a voice of your choice.
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     */
    convert(voiceId: string, request: ElevenLabs.BodySpeechToSpeechV1SpeechToSpeechVoiceIdPost, requestOptions?: SpeechToSpeech.RequestOptions): Promise<stream.Readable>;
    /**
     * Create speech by combining the content and emotion of the uploaded audio with a voice of your choice and returns an audio stream.
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     */
    convertAsStream(voiceId: string, request: ElevenLabs.BodySpeechToSpeechStreamingV1SpeechToSpeechVoiceIdStreamPost, requestOptions?: SpeechToSpeech.RequestOptions): Promise<stream.Readable>;
}
