/**
 * This file was auto-generated by Fern from our API Definition.
 */
/// <reference types="node" />
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
import * as stream from "stream";
export declare namespace History {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class History {
    protected readonly _options: History.Options;
    constructor(_options?: History.Options);
    /**
     * Returns metadata about all your generated audio.
     *
     * @param {ElevenLabs.HistoryGetAllRequest} request
     * @param {History.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.history.getAll({
     *         page_size: 1,
     *         voice_id: "pMsXgVXv3BLzUgSXRplE"
     *     })
     */
    getAll(request?: ElevenLabs.HistoryGetAllRequest, requestOptions?: History.RequestOptions): Promise<ElevenLabs.GetSpeechHistoryResponse>;
    /**
     * Returns information about an history item by its ID.
     *
     * @param {string} historyItemId - History item ID to be used, you can use GET https://api.elevenlabs.io/v1/history to receive a list of history items and their IDs.
     * @param {History.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.history.get("ja9xsmfGhxYcymxGcOGB")
     */
    get(historyItemId: string, requestOptions?: History.RequestOptions): Promise<ElevenLabs.SpeechHistoryItemResponse>;
    /**
     * Delete a history item by its ID
     *
     * @param {string} historyItemId - History item ID to be used, you can use GET https://api.elevenlabs.io/v1/history to receive a list of history items and their IDs.
     * @param {History.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.history.delete("ja9xsmfGhxYcymxGcOGB")
     */
    delete(historyItemId: string, requestOptions?: History.RequestOptions): Promise<unknown>;
    /**
     * Returns the audio of an history item.
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     */
    getAudio(historyItemId: string, requestOptions?: History.RequestOptions): Promise<stream.Readable>;
    /**
     * Download one or more history items. If one history item ID is provided, we will return a single audio file. If more than one history item IDs are provided, we will provide the history items packed into a .zip file.
     *
     * @param {ElevenLabs.DownloadHistoryRequest} request
     * @param {History.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.history.download({
     *         history_item_ids: ["ja9xsmfGhxYcymxGcOGB"]
     *     })
     */
    download(request: ElevenLabs.DownloadHistoryRequest, requestOptions?: History.RequestOptions): Promise<void>;
}
