"use strict";
/**
 * This file was auto-generated by Fern from our API Definition.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationalAi = void 0;
const environments = __importStar(require("../../../../environments"));
const core = __importStar(require("../../../../core"));
const ElevenLabs = __importStar(require("../../../index"));
const url_join_1 = __importDefault(require("url-join"));
const errors = __importStar(require("../../../../errors/index"));
class ConversationalAi {
    constructor(_options = {}) {
        this._options = _options;
    }
    /**
     * Get a signed url to start a conversation with an agent with an agent that requires authorization
     *
     * @param {ElevenLabs.ConversationalAiGetSignedUrlRequest} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getSignedUrl({
     *         agent_id: "21m00Tcm4TlvDq8ikWAM"
     *     })
     */
    getSignedUrl(request, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const { agent_id: agentId } = request;
            const _queryParams = {};
            _queryParams["agent_id"] = agentId;
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, "v1/convai/conversation/get_signed_url"),
                method: "GET",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                queryParameters: _queryParams,
                requestType: "json",
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Create an agent from a config object
     *
     * @param {ElevenLabs.BodyCreateAgentV1ConvaiAgentsCreatePost} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.createAgent({
     *         conversation_config: {}
     *     })
     */
    createAgent(request, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, "v1/convai/agents/create"),
                method: "POST",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                requestType: "json",
                body: request,
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Retrieve config for an agent
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getAgent("21m00Tcm4TlvDq8ikWAM")
     */
    getAgent(agentId, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/agents/${encodeURIComponent(agentId)}`),
                method: "GET",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                requestType: "json",
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Delete an agent
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.deleteAgent("21m00Tcm4TlvDq8ikWAM")
     */
    deleteAgent(agentId, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/agents/${encodeURIComponent(agentId)}`),
                method: "DELETE",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                requestType: "json",
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Patches an Agent settings
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ElevenLabs.BodyPatchesAnAgentSettingsV1ConvaiAgentsAgentIdPatch} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.updateAgent("21m00Tcm4TlvDq8ikWAM")
     */
    updateAgent(agentId, request = {}, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/agents/${encodeURIComponent(agentId)}`),
                method: "PATCH",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                requestType: "json",
                body: request,
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Retrieve the widget configuration for an agent
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ElevenLabs.ConversationalAiGetWidgetRequest} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getWidget("21m00Tcm4TlvDq8ikWAM")
     */
    getWidget(agentId, request = {}, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const { conversation_signature: conversationSignature } = request;
            const _queryParams = {};
            if (conversationSignature != null) {
                _queryParams["conversation_signature"] = conversationSignature;
            }
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/agents/${encodeURIComponent(agentId)}/widget`),
                method: "GET",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                queryParameters: _queryParams,
                requestType: "json",
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Get the current link used to share the agent with others
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getLink("21m00Tcm4TlvDq8ikWAM")
     */
    getLink(agentId, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/agents/${encodeURIComponent(agentId)}/link`),
                method: "GET",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                requestType: "json",
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Sets the avatar for an agent displayed in the widget
     *
     * @param {string} agentId
     * @param {ElevenLabs.BodyPostAgentAvatarV1ConvaiAgentsAgentIdAvatarPost} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.postAvatar("21m00Tcm4TlvDq8ikWAM", {
     *         avatar_file: fs.createReadStream("/path/to/your/file")
     *     })
     */
    postAvatar(agentId, request, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _request = yield core.newFormData();
            yield _request.appendFile("avatar_file", request.avatar_file);
            const _maybeEncodedRequest = yield _request.getRequest();
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/agents/${encodeURIComponent(agentId)}/avatar`),
                method: "POST",
                headers: Object.assign({ "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined, "X-Fern-Language": "JavaScript", "X-Fern-SDK-Name": "elevenlabs", "X-Fern-SDK-Version": "0.18.1", "User-Agent": "elevenlabs/0.18.1", "X-Fern-Runtime": core.RUNTIME.type, "X-Fern-Runtime-Version": core.RUNTIME.version }, _maybeEncodedRequest.headers),
                requestType: "file",
                duplex: _maybeEncodedRequest.duplex,
                body: _maybeEncodedRequest.body,
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Get details about a specific documentation making up the agent's knowledge base
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {string} documentationId - The id of a document from the agent's knowledge base. This is returned on document addition.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getKnowledgeBaseDocument("21m00Tcm4TlvDq8ikWAM", "21m00Tcm4TlvDq8ikWAM")
     */
    getKnowledgeBaseDocument(agentId, documentationId, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/agents/${encodeURIComponent(agentId)}/knowledge-base/${encodeURIComponent(documentationId)}`),
                method: "GET",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                requestType: "json",
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Uploads a file or reference a webpage for the agent to use as part of it's knowledge base
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ElevenLabs.BodyAddASecretToTheAgentWhichCanBeReferencedInToolCallsV1ConvaiAgentsAgentIdAddSecretPost} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.addAgentSecret("21m00Tcm4TlvDq8ikWAM", {
     *         name: "name",
     *         secret_value: "secret_value"
     *     })
     */
    addAgentSecret(agentId, request, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/agents/${encodeURIComponent(agentId)}/add-secret`),
                method: "POST",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                requestType: "json",
                body: request,
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Uploads a file or reference a webpage for the agent to use as part of it's knowledge base
     *
     * @param {string} agentId
     * @param {ElevenLabs.BodyAddToAgentSKnowledgeBaseV1ConvaiAgentsAgentIdAddToKnowledgeBasePost} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.createKnowledgeBaseDocument("21m00Tcm4TlvDq8ikWAM", {})
     */
    createKnowledgeBaseDocument(agentId, request, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _request = yield core.newFormData();
            if (request.url != null) {
                yield _request.append("url", request.url);
            }
            if (request.file != null) {
                yield _request.appendFile("file", request.file);
            }
            const _maybeEncodedRequest = yield _request.getRequest();
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/agents/${encodeURIComponent(agentId)}/add-to-knowledge-base`),
                method: "POST",
                headers: Object.assign({ "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined, "X-Fern-Language": "JavaScript", "X-Fern-SDK-Name": "elevenlabs", "X-Fern-SDK-Version": "0.18.1", "User-Agent": "elevenlabs/0.18.1", "X-Fern-Runtime": core.RUNTIME.type, "X-Fern-Runtime-Version": core.RUNTIME.version }, _maybeEncodedRequest.headers),
                requestType: "file",
                duplex: _maybeEncodedRequest.duplex,
                body: _maybeEncodedRequest.body,
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Returns a page of your agents and their metadata.
     *
     * @param {ElevenLabs.ConversationalAiGetAgentsRequest} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getAgents()
     */
    getAgents(request = {}, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const { cursor, page_size: pageSize, search } = request;
            const _queryParams = {};
            if (cursor != null) {
                _queryParams["cursor"] = cursor;
            }
            if (pageSize != null) {
                _queryParams["page_size"] = pageSize.toString();
            }
            if (search != null) {
                _queryParams["search"] = search;
            }
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, "v1/convai/agents"),
                method: "GET",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                queryParameters: _queryParams,
                requestType: "json",
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Get all conversations of agents that user owns. With option to restrict to a specific agent.
     *
     * @param {ElevenLabs.ConversationalAiGetConversationsRequest} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getConversations({
     *         agent_id: "21m00Tcm4TlvDq8ikWAM"
     *     })
     */
    getConversations(request = {}, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const { cursor, agent_id: agentId, call_successful: callSuccessful, page_size: pageSize } = request;
            const _queryParams = {};
            if (cursor != null) {
                _queryParams["cursor"] = cursor;
            }
            if (agentId != null) {
                _queryParams["agent_id"] = agentId;
            }
            if (callSuccessful != null) {
                _queryParams["call_successful"] = callSuccessful;
            }
            if (pageSize != null) {
                _queryParams["page_size"] = pageSize.toString();
            }
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, "v1/convai/conversations"),
                method: "GET",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                queryParameters: _queryParams,
                requestType: "json",
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Get the details of a particular conversation
     *
     * @param {string} conversationId - The id of the conversation you're taking the action on.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getConversation("21m00Tcm4TlvDq8ikWAM")
     */
    getConversation(conversationId, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/conversations/${encodeURIComponent(conversationId)}`),
                method: "GET",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                requestType: "json",
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
    /**
     * Get the audio recording of a particular conversation
     *
     * @param {string} conversationId - The id of the conversation you're taking the action on.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getConversationAudio("21m00Tcm4TlvDq8ikWAM")
     */
    getConversationAudio(conversationId, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, `v1/convai/conversations/${encodeURIComponent(conversationId)}/audio`),
                method: "GET",
                headers: {
                    "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined,
                    "X-Fern-Language": "JavaScript",
                    "X-Fern-SDK-Name": "elevenlabs",
                    "X-Fern-SDK-Version": "0.18.1",
                    "User-Agent": "elevenlabs/0.18.1",
                    "X-Fern-Runtime": core.RUNTIME.type,
                    "X-Fern-Runtime-Version": core.RUNTIME.version,
                },
                contentType: "application/json",
                requestType: "json",
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
}
exports.ConversationalAi = ConversationalAi;
