"use strict";
/**
 * This file was auto-generated by Fern from our API Definition.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AudioNative = void 0;
const environments = __importStar(require("../../../../environments"));
const core = __importStar(require("../../../../core"));
const ElevenLabs = __importStar(require("../../../index"));
const url_join_1 = __importDefault(require("url-join"));
const errors = __importStar(require("../../../../errors/index"));
class AudioNative {
    constructor(_options = {}) {
        this._options = _options;
    }
    /**
     * Creates AudioNative enabled project, optionally starts conversion and returns project id and embeddable html snippet.
     *
     * @param {ElevenLabs.BodyCreatesAudioNativeEnabledProjectV1AudioNativePost} request
     * @param {AudioNative.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.audioNative.create({
     *         name: "name"
     *     })
     */
    create(request, requestOptions) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const _request = yield core.newFormData();
            yield _request.append("name", request.name);
            if (request.image != null) {
                yield _request.append("image", request.image);
            }
            if (request.author != null) {
                yield _request.append("author", request.author);
            }
            if (request.title != null) {
                yield _request.append("title", request.title);
            }
            if (request.small != null) {
                yield _request.append("small", request.small.toString());
            }
            if (request.text_color != null) {
                yield _request.append("text_color", request.text_color);
            }
            if (request.background_color != null) {
                yield _request.append("background_color", request.background_color);
            }
            if (request.sessionization != null) {
                yield _request.append("sessionization", request.sessionization.toString());
            }
            if (request.voice_id != null) {
                yield _request.append("voice_id", request.voice_id);
            }
            if (request.model_id != null) {
                yield _request.append("model_id", request.model_id);
            }
            if (request.file != null) {
                yield _request.appendFile("file", request.file);
            }
            if (request.auto_convert != null) {
                yield _request.append("auto_convert", request.auto_convert.toString());
            }
            const _maybeEncodedRequest = yield _request.getRequest();
            const _response = yield core.fetcher({
                url: (0, url_join_1.default)((_a = (yield core.Supplier.get(this._options.environment))) !== null && _a !== void 0 ? _a : environments.ElevenLabsEnvironment.Production, "v1/audio-native"),
                method: "POST",
                headers: Object.assign({ "xi-api-key": (yield core.Supplier.get(this._options.apiKey)) != null
                        ? yield core.Supplier.get(this._options.apiKey)
                        : undefined, "X-Fern-Language": "JavaScript", "X-Fern-SDK-Name": "elevenlabs", "X-Fern-SDK-Version": "0.18.1", "User-Agent": "elevenlabs/0.18.1", "X-Fern-Runtime": core.RUNTIME.type, "X-Fern-Runtime-Version": core.RUNTIME.version }, _maybeEncodedRequest.headers),
                requestType: "file",
                duplex: _maybeEncodedRequest.duplex,
                body: _maybeEncodedRequest.body,
                timeoutMs: (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeoutInSeconds) != null ? requestOptions.timeoutInSeconds * 1000 : 60000,
                maxRetries: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.maxRetries,
                abortSignal: requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.abortSignal,
            });
            if (_response.ok) {
                return _response.body;
            }
            if (_response.error.reason === "status-code") {
                switch (_response.error.statusCode) {
                    case 422:
                        throw new ElevenLabs.UnprocessableEntityError(_response.error.body);
                    default:
                        throw new errors.ElevenLabsError({
                            statusCode: _response.error.statusCode,
                            body: _response.error.body,
                        });
                }
            }
            switch (_response.error.reason) {
                case "non-json":
                    throw new errors.ElevenLabsError({
                        statusCode: _response.error.statusCode,
                        body: _response.error.rawBody,
                    });
                case "timeout":
                    throw new errors.ElevenLabsTimeoutError();
                case "unknown":
                    throw new errors.ElevenLabsError({
                        message: _response.error.errorMessage,
                    });
            }
        });
    }
}
exports.AudioNative = AudioNative;
