/**
 * This file was auto-generated by Fern from our API Definition.
 */
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
export declare namespace Workspace {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class Workspace {
    protected readonly _options: Workspace.Options;
    constructor(_options?: Workspace.Options);
    /**
     * Sends an email invitation to join your workspace to the provided email. If the user doesn't have an account they will be prompted to create one. If the user accepts this invite they will be added as a user to your workspace and your subscription using one of your seats. This endpoint may only be called by workspace administrators.
     *
     * @param {ElevenLabs.BodyInviteUserV1WorkspaceInvitesAddPost} request
     * @param {Workspace.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.workspace.inviteUser({
     *         email: "email"
     *     })
     */
    inviteUser(request: ElevenLabs.BodyInviteUserV1WorkspaceInvitesAddPost, requestOptions?: Workspace.RequestOptions): Promise<unknown>;
    /**
     * Invalidates an existing email invitation. The invitation will still show up in the inbox it has been delivered to, but activating it to join the workspace won't work. This endpoint may only be called by workspace administrators.
     *
     * @param {ElevenLabs.BodyDeleteExistingInvitationV1WorkspaceInvitesDelete} request
     * @param {Workspace.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.workspace.deleteExistingInvitation({
     *         email: "email"
     *     })
     */
    deleteExistingInvitation(request: ElevenLabs.BodyDeleteExistingInvitationV1WorkspaceInvitesDelete, requestOptions?: Workspace.RequestOptions): Promise<unknown>;
    /**
     * Updates attributes of a workspace member. Apart from the email identifier, all parameters will remain unchanged unless specified. This endpoint may only be called by workspace administrators.
     *
     * @param {ElevenLabs.BodyUpdateMemberV1WorkspaceMembersPost} request
     * @param {Workspace.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.workspace.updateMember({
     *         email: "email"
     *     })
     */
    updateMember(request: ElevenLabs.BodyUpdateMemberV1WorkspaceMembersPost, requestOptions?: Workspace.RequestOptions): Promise<unknown>;
}
