/**
 * This file was auto-generated by Fern from our API Definition.
 */
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
export declare namespace Usage {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class Usage {
    protected readonly _options: Usage.Options;
    constructor(_options?: Usage.Options);
    /**
     * Returns the credit usage metrics for the current user or the entire workspace they are part of. The response will return a time axis with unix timestamps for each day and daily usage along that axis. The usage will be broken down by the specified breakdown type. For example, breakdown type "voice" will return the usage of each voice along the time axis.
     *
     * @param {ElevenLabs.UsageGetCharactersUsageMetricsRequest} request
     * @param {Usage.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.usage.getCharactersUsageMetrics({
     *         start_unix: 1,
     *         end_unix: 1
     *     })
     */
    getCharactersUsageMetrics(request: ElevenLabs.UsageGetCharactersUsageMetricsRequest, requestOptions?: Usage.RequestOptions): Promise<ElevenLabs.UsageCharactersResponseModel>;
}
