/**
 * This file was auto-generated by Fern from our API Definition.
 */
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
export declare namespace TextToVoice {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class TextToVoice {
    protected readonly _options: TextToVoice.Options;
    constructor(_options?: TextToVoice.Options);
    /**
     * Generate a custom voice based on voice description. This method returns a list of voice previews. Each preview has a generated_voice_id and a sample of the voice as base64 encoded mp3 audio. If you like the a voice previewand want to create the voice call /v1/text-to-voice/create-voice-from-preview with the generated_voice_id to create the voice.
     *
     * @param {ElevenLabs.VoicePreviewsRequestModel} request
     * @param {TextToVoice.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.textToVoice.createPreviews({
     *         voice_description: "A sassy little squeaky mouse",
     *         text: "Every act of kindness, no matter how small, carries value and can make a difference, as no gesture of goodwill is ever wasted."
     *     })
     */
    createPreviews(request: ElevenLabs.VoicePreviewsRequestModel, requestOptions?: TextToVoice.RequestOptions): Promise<ElevenLabs.VoicePreviewsResponseModel>;
    /**
     * Create a voice from previously generated voice preview. This endpoint should be called after you fetched a generated_voice_id using /v1/text-to-voice/create-previews.
     *
     * @param {ElevenLabs.BodyCreateANewVoiceFromVoicePreviewV1TextToVoiceCreateVoiceFromPreviewPost} request
     * @param {TextToVoice.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.textToVoice.createVoiceFromPreview({
     *         voice_name: "Little squeaky mouse",
     *         voice_description: "A sassy little squeaky mouse",
     *         generated_voice_id: "37HceQefKmEi3bGovXjL"
     *     })
     */
    createVoiceFromPreview(request: ElevenLabs.BodyCreateANewVoiceFromVoicePreviewV1TextToVoiceCreateVoiceFromPreviewPost, requestOptions?: TextToVoice.RequestOptions): Promise<ElevenLabs.Voice>;
}
