/**
 * This file was auto-generated by Fern from our API Definition.
 */
/// <reference types="node" />
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
import * as stream from "stream";
export declare namespace Projects {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
/**
 * Access, create and convert Projects programmatically, only specifically whitelisted accounts can access the Projects API. If you need access please contact our sales team.
 */
export declare class Projects {
    protected readonly _options: Projects.Options;
    constructor(_options?: Projects.Options);
    /**
     * Returns a list of your projects together and its metadata.
     *
     * @param {Projects.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.projects.getAll()
     */
    getAll(requestOptions?: Projects.RequestOptions): Promise<ElevenLabs.GetProjectsResponse>;
    /**
     * Creates a new project, it can be either initialized as blank, from a document or from a URL.
     *
     * @param {ElevenLabs.BodyAddProjectV1ProjectsAddPost} request
     * @param {Projects.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.projects.add({
     *         name: "name",
     *         default_title_voice_id: "default_title_voice_id",
     *         default_paragraph_voice_id: "default_paragraph_voice_id",
     *         default_model_id: "default_model_id"
     *     })
     */
    add(request: ElevenLabs.BodyAddProjectV1ProjectsAddPost, requestOptions?: Projects.RequestOptions): Promise<ElevenLabs.AddProjectResponseModel>;
    /**
     * Returns information about a specific project. This endpoint returns more detailed information about a project than GET api.elevenlabs.io/v1/projects.
     *
     * @param {string} projectId - The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     * @param {Projects.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.projects.get("21m00Tcm4TlvDq8ikWAM")
     */
    get(projectId: string, requestOptions?: Projects.RequestOptions): Promise<ElevenLabs.ProjectExtendedResponseModel>;
    /**
     * Edits basic project info.
     *
     * @param {string} projectId - The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     * @param {ElevenLabs.BodyEditBasicProjectInfoV1ProjectsProjectIdPost} request
     * @param {Projects.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.projects.editBasicProjectInfo("21m00Tcm4TlvDq8ikWAM", {
     *         name: "name",
     *         default_title_voice_id: "default_title_voice_id",
     *         default_paragraph_voice_id: "default_paragraph_voice_id"
     *     })
     */
    editBasicProjectInfo(projectId: string, request: ElevenLabs.BodyEditBasicProjectInfoV1ProjectsProjectIdPost, requestOptions?: Projects.RequestOptions): Promise<ElevenLabs.EditProjectResponseModel>;
    /**
     * Delete a project by its project_id.
     *
     * @param {string} projectId - The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     * @param {Projects.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.projects.delete("21m00Tcm4TlvDq8ikWAM")
     */
    delete(projectId: string, requestOptions?: Projects.RequestOptions): Promise<unknown>;
    /**
     * Starts conversion of a project and all of its chapters.
     *
     * @param {string} projectId - The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     * @param {Projects.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.projects.convert("21m00Tcm4TlvDq8ikWAM")
     */
    convert(projectId: string, requestOptions?: Projects.RequestOptions): Promise<unknown>;
    /**
     * Gets the snapshots of a project.
     *
     * @param {string} projectId - The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     * @param {Projects.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.projects.getSnapshots("21m00Tcm4TlvDq8ikWAM")
     */
    getSnapshots(projectId: string, requestOptions?: Projects.RequestOptions): Promise<ElevenLabs.ProjectSnapshotsResponse>;
    /**
     * Stream the audio from a project snapshot.
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     */
    streamAudio(projectId: string, projectSnapshotId: string, request?: ElevenLabs.BodyStreamProjectAudioV1ProjectsProjectIdSnapshotsProjectSnapshotIdStreamPost, requestOptions?: Projects.RequestOptions): Promise<stream.Readable>;
    /**
     * Streams archive with project audio.
     *
     * @param {string} projectId - The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     * @param {string} projectSnapshotId - The project_snapshot_id of the project snapshot. You can query GET /v1/projects/{project_id}/snapshots to list all available snapshots for a project.
     * @param {Projects.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.projects.streamArchive("21m00Tcm4TlvDq8ikWAM", "21m00Tcm4TlvDq8ikWAM")
     */
    streamArchive(projectId: string, projectSnapshotId: string, requestOptions?: Projects.RequestOptions): Promise<void>;
    /**
     * Creates a new chapter either as blank or from a URL.
     *
     * @param {string} projectId - The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     * @param {ElevenLabs.BodyAddChapterToAProjectV1ProjectsProjectIdChaptersAddPost} request
     * @param {Projects.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.projects.addChapterToAProject("21m00Tcm4TlvDq8ikWAM", {
     *         name: "name"
     *     })
     */
    addChapterToAProject(projectId: string, request: ElevenLabs.BodyAddChapterToAProjectV1ProjectsProjectIdChaptersAddPost, requestOptions?: Projects.RequestOptions): Promise<ElevenLabs.AddChapterResponseModel>;
    /**
     * Updates the set of pronunciation dictionaries acting on a project. This will automatically mark text within this project as requiring reconverting where the new dictionary would apply or the old one no longer does.
     *
     * @param {string} projectId - The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     * @param {ElevenLabs.UpdatePronunciationDictionariesRequest} request
     * @param {Projects.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.projects.updatePronunciationDictionaries("21m00Tcm4TlvDq8ikWAM", {
     *         pronunciation_dictionary_locators: [{
     *                 pronunciation_dictionary_id: "pronunciation_dictionary_id",
     *                 version_id: "version_id"
     *             }]
     *     })
     */
    updatePronunciationDictionaries(projectId: string, request: ElevenLabs.UpdatePronunciationDictionariesRequest, requestOptions?: Projects.RequestOptions): Promise<unknown>;
}
