/**
 * This file was auto-generated by Fern from our API Definition.
 */
/// <reference types="node" />
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
import * as stream from "stream";
export declare namespace Dubbing {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class Dubbing {
    protected readonly _options: Dubbing.Options;
    constructor(_options?: Dubbing.Options);
    /**
     * Dubs provided audio or video file into given language.
     *
     * @param {ElevenLabs.BodyDubAVideoOrAnAudioFileV1DubbingPost} request
     * @param {Dubbing.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.dubbing.dubAVideoOrAnAudioFile({
     *         target_lang: "target_lang"
     *     })
     */
    dubAVideoOrAnAudioFile(request: ElevenLabs.BodyDubAVideoOrAnAudioFileV1DubbingPost, requestOptions?: Dubbing.RequestOptions): Promise<ElevenLabs.DoDubbingResponse>;
    /**
     * Returns metadata about a dubbing project, including whether it's still in progress or not
     *
     * @param {string} dubbingId - ID of the dubbing project.
     * @param {Dubbing.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.dubbing.getDubbingProjectMetadata("dubbing_id")
     */
    getDubbingProjectMetadata(dubbingId: string, requestOptions?: Dubbing.RequestOptions): Promise<ElevenLabs.DubbingMetadataResponse>;
    /**
     * Deletes a dubbing project.
     *
     * @param {string} dubbingId - ID of the dubbing project.
     * @param {Dubbing.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.dubbing.deleteDubbingProject("dubbing_id")
     */
    deleteDubbingProject(dubbingId: string, requestOptions?: Dubbing.RequestOptions): Promise<unknown>;
    /**
     * Returns dubbed file as a streamed file. Videos will be returned in MP4 format and audio only dubs will be returned in MP3.
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     */
    getDubbedFile(dubbingId: string, languageCode: string, requestOptions?: Dubbing.RequestOptions): Promise<stream.Readable>;
    /**
     * Returns transcript for the dub as an SRT file.
     *
     * @param {string} dubbingId - ID of the dubbing project.
     * @param {string} languageCode - ID of the language.
     * @param {ElevenLabs.GetTranscriptForDubV1DubbingDubbingIdTranscriptLanguageCodeGetRequest} request
     * @param {Dubbing.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.dubbing.getTranscriptForDub("dubbing_id", "language_code")
     */
    getTranscriptForDub(dubbingId: string, languageCode: string, request?: ElevenLabs.GetTranscriptForDubV1DubbingDubbingIdTranscriptLanguageCodeGetRequest, requestOptions?: Dubbing.RequestOptions): Promise<unknown>;
}
