/**
 * This file was auto-generated by Fern from our API Definition.
 */
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
export declare namespace ConversationalAi {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class ConversationalAi {
    protected readonly _options: ConversationalAi.Options;
    constructor(_options?: ConversationalAi.Options);
    /**
     * Get a signed url to start a conversation with an agent with an agent that requires authorization
     *
     * @param {ElevenLabs.ConversationalAiGetSignedUrlRequest} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getSignedUrl({
     *         agent_id: "21m00Tcm4TlvDq8ikWAM"
     *     })
     */
    getSignedUrl(request: ElevenLabs.ConversationalAiGetSignedUrlRequest, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.ConversationSignedUrlResponseModel>;
    /**
     * Create an agent from a config object
     *
     * @param {ElevenLabs.BodyCreateAgentV1ConvaiAgentsCreatePost} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.createAgent({
     *         conversation_config: {}
     *     })
     */
    createAgent(request: ElevenLabs.BodyCreateAgentV1ConvaiAgentsCreatePost, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.CreateAgentResponseModel>;
    /**
     * Retrieve config for an agent
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getAgent("21m00Tcm4TlvDq8ikWAM")
     */
    getAgent(agentId: string, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.GetAgentResponseModel>;
    /**
     * Delete an agent
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.deleteAgent("21m00Tcm4TlvDq8ikWAM")
     */
    deleteAgent(agentId: string, requestOptions?: ConversationalAi.RequestOptions): Promise<Record<string, string>>;
    /**
     * Patches an Agent settings
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ElevenLabs.BodyPatchesAnAgentSettingsV1ConvaiAgentsAgentIdPatch} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.updateAgent("21m00Tcm4TlvDq8ikWAM")
     */
    updateAgent(agentId: string, request?: ElevenLabs.BodyPatchesAnAgentSettingsV1ConvaiAgentsAgentIdPatch, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.GetAgentResponseModel>;
    /**
     * Retrieve the widget configuration for an agent
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ElevenLabs.ConversationalAiGetWidgetRequest} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getWidget("21m00Tcm4TlvDq8ikWAM")
     */
    getWidget(agentId: string, request?: ElevenLabs.ConversationalAiGetWidgetRequest, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.GetAgentEmbedResponseModel>;
    /**
     * Get the current link used to share the agent with others
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getLink("21m00Tcm4TlvDq8ikWAM")
     */
    getLink(agentId: string, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.GetAgentLinkResponseModel>;
    /**
     * Sets the avatar for an agent displayed in the widget
     *
     * @param {string} agentId
     * @param {ElevenLabs.BodyPostAgentAvatarV1ConvaiAgentsAgentIdAvatarPost} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.postAvatar("21m00Tcm4TlvDq8ikWAM", {
     *         avatar_file: fs.createReadStream("/path/to/your/file")
     *     })
     */
    postAvatar(agentId: string, request: ElevenLabs.BodyPostAgentAvatarV1ConvaiAgentsAgentIdAvatarPost, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.PostAgentAvatarResponseModel>;
    /**
     * Get details about a specific documentation making up the agent's knowledge base
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {string} documentationId - The id of a document from the agent's knowledge base. This is returned on document addition.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getKnowledgeBaseDocument("21m00Tcm4TlvDq8ikWAM", "21m00Tcm4TlvDq8ikWAM")
     */
    getKnowledgeBaseDocument(agentId: string, documentationId: string, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.GetKnowledgeBaseReponseModel>;
    /**
     * Uploads a file or reference a webpage for the agent to use as part of it's knowledge base
     *
     * @param {string} agentId - The id of an agent. This is returned on agent creation.
     * @param {ElevenLabs.BodyAddASecretToTheAgentWhichCanBeReferencedInToolCallsV1ConvaiAgentsAgentIdAddSecretPost} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.addAgentSecret("21m00Tcm4TlvDq8ikWAM", {
     *         name: "name",
     *         secret_value: "secret_value"
     *     })
     */
    addAgentSecret(agentId: string, request: ElevenLabs.BodyAddASecretToTheAgentWhichCanBeReferencedInToolCallsV1ConvaiAgentsAgentIdAddSecretPost, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.AddAgentSecretResponseModel>;
    /**
     * Uploads a file or reference a webpage for the agent to use as part of it's knowledge base
     *
     * @param {string} agentId
     * @param {ElevenLabs.BodyAddToAgentSKnowledgeBaseV1ConvaiAgentsAgentIdAddToKnowledgeBasePost} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.createKnowledgeBaseDocument("21m00Tcm4TlvDq8ikWAM", {})
     */
    createKnowledgeBaseDocument(agentId: string, request: ElevenLabs.BodyAddToAgentSKnowledgeBaseV1ConvaiAgentsAgentIdAddToKnowledgeBasePost, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.AddKnowledgeBaseResponseModel>;
    /**
     * Returns a page of your agents and their metadata.
     *
     * @param {ElevenLabs.ConversationalAiGetAgentsRequest} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getAgents()
     */
    getAgents(request?: ElevenLabs.ConversationalAiGetAgentsRequest, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.GetAgentsPageResponseModel>;
    /**
     * Get all conversations of agents that user owns. With option to restrict to a specific agent.
     *
     * @param {ElevenLabs.ConversationalAiGetConversationsRequest} request
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getConversations({
     *         agent_id: "21m00Tcm4TlvDq8ikWAM"
     *     })
     */
    getConversations(request?: ElevenLabs.ConversationalAiGetConversationsRequest, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.GetConversationsPageResponseModel>;
    /**
     * Get the details of a particular conversation
     *
     * @param {string} conversationId - The id of the conversation you're taking the action on.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getConversation("21m00Tcm4TlvDq8ikWAM")
     */
    getConversation(conversationId: string, requestOptions?: ConversationalAi.RequestOptions): Promise<ElevenLabs.GetConversationResponseModel>;
    /**
     * Get the audio recording of a particular conversation
     *
     * @param {string} conversationId - The id of the conversation you're taking the action on.
     * @param {ConversationalAi.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.conversationalAi.getConversationAudio("21m00Tcm4TlvDq8ikWAM")
     */
    getConversationAudio(conversationId: string, requestOptions?: ConversationalAi.RequestOptions): Promise<void>;
}
