/**
 * This file was auto-generated by Fern from our API Definition.
 */
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
export declare namespace AudioNative {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class AudioNative {
    protected readonly _options: AudioNative.Options;
    constructor(_options?: AudioNative.Options);
    /**
     * Creates AudioNative enabled project, optionally starts conversion and returns project id and embeddable html snippet.
     *
     * @param {ElevenLabs.BodyCreatesAudioNativeEnabledProjectV1AudioNativePost} request
     * @param {AudioNative.RequestOptions} requestOptions - Request-specific configuration.
     *
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     *
     * @example
     *     await client.audioNative.create({
     *         name: "name"
     *     })
     */
    create(request: ElevenLabs.BodyCreatesAudioNativeEnabledProjectV1AudioNativePost, requestOptions?: AudioNative.RequestOptions): Promise<ElevenLabs.AudioNativeCreateProjectResponseModel>;
}
