/**
 * This file was auto-generated by Fern from our API Definition.
 */
/// <reference types="node" />
import * as environments from "../../../../environments";
import * as core from "../../../../core";
import * as ElevenLabs from "../../../index";
import * as stream from "stream";
export declare namespace AudioIsolation {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class AudioIsolation {
    protected readonly _options: AudioIsolation.Options;
    constructor(_options?: AudioIsolation.Options);
    /**
     * Removes background noise from audio
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     */
    audioIsolation(request: ElevenLabs.BodyAudioIsolationV1AudioIsolationPost, requestOptions?: AudioIsolation.RequestOptions): Promise<stream.Readable>;
    /**
     * Removes background noise from audio and streams the result
     * @throws {@link ElevenLabs.UnprocessableEntityError}
     */
    audioIsolationStream(request: ElevenLabs.BodyAudioIsolationStreamV1AudioIsolationStreamPost, requestOptions?: AudioIsolation.RequestOptions): Promise<stream.Readable>;
}
