/**
 * This file was auto-generated by Fern from our API Definition.
 */
import * as environments from "./environments";
import * as core from "./core";
import { History } from "./api/resources/history/client/Client";
import { TextToSoundEffects } from "./api/resources/textToSoundEffects/client/Client";
import { AudioIsolation } from "./api/resources/audioIsolation/client/Client";
import { Samples } from "./api/resources/samples/client/Client";
import { TextToSpeech } from "./api/resources/textToSpeech/client/Client";
import { SpeechToSpeech } from "./api/resources/speechToSpeech/client/Client";
import { VoiceGeneration } from "./api/resources/voiceGeneration/client/Client";
import { TextToVoice } from "./api/resources/textToVoice/client/Client";
import { User } from "./api/resources/user/client/Client";
import { Voices } from "./api/resources/voices/client/Client";
import { Projects } from "./api/resources/projects/client/Client";
import { Chapters } from "./api/resources/chapters/client/Client";
import { Dubbing } from "./api/resources/dubbing/client/Client";
import { Models } from "./api/resources/models/client/Client";
import { AudioNative } from "./api/resources/audioNative/client/Client";
import { Usage } from "./api/resources/usage/client/Client";
import { PronunciationDictionary } from "./api/resources/pronunciationDictionary/client/Client";
import { Workspace } from "./api/resources/workspace/client/Client";
import { ConversationalAi } from "./api/resources/conversationalAi/client/Client";
export declare namespace ElevenLabsClient {
    interface Options {
        environment?: core.Supplier<environments.ElevenLabsEnvironment | string>;
        /** Override the xi-api-key header */
        apiKey?: core.Supplier<string | undefined>;
    }
    interface RequestOptions {
        /** The maximum time to wait for a response in seconds. */
        timeoutInSeconds?: number;
        /** The number of times to retry the request. Defaults to 2. */
        maxRetries?: number;
        /** A hook to abort the request. */
        abortSignal?: AbortSignal;
        /** Override the xi-api-key header */
        apiKey?: string | undefined;
    }
}
export declare class ElevenLabsClient {
    protected readonly _options: ElevenLabsClient.Options;
    constructor(_options?: ElevenLabsClient.Options);
    protected _history: History | undefined;
    get history(): History;
    protected _textToSoundEffects: TextToSoundEffects | undefined;
    get textToSoundEffects(): TextToSoundEffects;
    protected _audioIsolation: AudioIsolation | undefined;
    get audioIsolation(): AudioIsolation;
    protected _samples: Samples | undefined;
    get samples(): Samples;
    protected _textToSpeech: TextToSpeech | undefined;
    get textToSpeech(): TextToSpeech;
    protected _speechToSpeech: SpeechToSpeech | undefined;
    get speechToSpeech(): SpeechToSpeech;
    protected _voiceGeneration: VoiceGeneration | undefined;
    get voiceGeneration(): VoiceGeneration;
    protected _textToVoice: TextToVoice | undefined;
    get textToVoice(): TextToVoice;
    protected _user: User | undefined;
    get user(): User;
    protected _voices: Voices | undefined;
    get voices(): Voices;
    protected _projects: Projects | undefined;
    get projects(): Projects;
    protected _chapters: Chapters | undefined;
    get chapters(): Chapters;
    protected _dubbing: Dubbing | undefined;
    get dubbing(): Dubbing;
    protected _models: Models | undefined;
    get models(): Models;
    protected _audioNative: AudioNative | undefined;
    get audioNative(): AudioNative;
    protected _usage: Usage | undefined;
    get usage(): Usage;
    protected _pronunciationDictionary: PronunciationDictionary | undefined;
    get pronunciationDictionary(): PronunciationDictionary;
    protected _workspace: Workspace | undefined;
    get workspace(): Workspace;
    protected _conversationalAi: ConversationalAi | undefined;
    get conversationalAi(): ConversationalAi;
}
